/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization;

import com.rapidminer.datatable.DataTableExampleSetAdapter;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.plotter.Plotter;
import com.rapidminer.gui.plotter.PlotterPanel;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ResultObjectAdapter;
import com.rapidminer.operator.visualization.SOMModelPlotter;
import java.awt.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOMModelVisualization
extends Operator {
    public SOMModelVisualization(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        Model model = this.getInput(Model.class);
        return new IOObject[]{exampleSet, model, new ModelVisualization(exampleSet, model)};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class, Model.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class, Model.class};
    }

    private static class ModelVisualization
    extends ResultObjectAdapter {
        private static final long serialVersionUID = -6250201023324000922L;
        private ExampleSet exampleSet;
        private Model model;

        public ModelVisualization(ExampleSet exampleSet, Model model) {
            this.exampleSet = exampleSet;
            this.model = model;
        }

        public Component getVisualizationComponent(IOContainer container) {
            DataTableExampleSetAdapter table = new DataTableExampleSetAdapter(this.exampleSet, null);
            PlotterPanel panel = new PlotterPanel(table, PlotterPanel.MODEL_PLOTTER_SELECTION);
            Plotter plotter = panel.getSelectedPlotter();
            plotter.setDataTable(table);
            ((SOMModelPlotter)plotter).setExampleSet(this.exampleSet);
            ((SOMModelPlotter)plotter).setModel(this.model);
            return panel;
        }

        public String getName() {
            return "ModelVisualization";
        }

        public boolean isSavable() {
            return false;
        }

        public String getExtension() {
            return "mvs";
        }

        public String getFileDescription() {
            return "model visualization";
        }
    }
}

