/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.function.expressions;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class ParseNumber
extends PostfixMathCommand {
    public ParseNumber() {
        this.numberOfParameters = 1;
    }

    public void run(Stack stack) throws ParseException {
        if (stack.size() < 1) {
            throw new ParseException("Needs one argument: The string to be converted into a number");
        }
        Object value = stack.pop();
        if (!(value instanceof String)) {
            throw new ParseException("Invalid argument type, only strings are supported.");
        }
        try {
            stack.push(Double.parseDouble((String)value));
        }
        catch (NumberFormatException e) {
            throw new ParseException("String '" + value + "' is not a number.");
        }
    }
}

