/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.chunker;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.chunker.ChunkerEvaluator;
import opennlp.tools.chunker.ChunkerME;
import opennlp.tools.chunker.ChunkerModel;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.chunker.ChunkerModelLoader;
import opennlp.tools.cmdline.chunker.ChunkerTrainerTool;
import opennlp.tools.util.ObjectStream;

public final class ChunkerEvaluatorTool
implements CmdLineTool {
    public String getName() {
        return "ChunkerEvaluator";
    }

    public String getShortDescription() {
        return "Measures the performance of the Chunker model with the reference data";
    }

    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " " + ArgumentParser.createUsage(Parameters.class);
    }

    public void run(String[] args) {
        if (!ArgumentParser.validateArguments(args, Parameters.class)) {
            System.err.println(this.getHelp());
            throw new TerminateToolException(1);
        }
        Parameters params = ArgumentParser.parse(args, Parameters.class);
        File testData = new File(params.getData());
        CmdLineUtil.checkInputFile("Test data", testData);
        Charset encoding = Charset.forName(params.getEncoding());
        if (encoding == null) {
            System.out.println(this.getHelp());
            throw new TerminateToolException(1);
        }
        ChunkerModel model = (ChunkerModel)new ChunkerModelLoader().load(new File(params.getModel()));
        ChunkerEvaluator evaluator = new ChunkerEvaluator(new ChunkerME(model));
        final ObjectStream<ChunkSample> sampleStream = ChunkerTrainerTool.openSampleData("Test", testData, encoding);
        final PerformanceMonitor monitor = new PerformanceMonitor("sent");
        ObjectStream<ChunkSample> measuredSampleStream = new ObjectStream<ChunkSample>(){

            @Override
            public ChunkSample read() throws IOException {
                monitor.incrementCounter();
                return (ChunkSample)sampleStream.read();
            }

            @Override
            public void reset() throws IOException {
                sampleStream.reset();
            }

            @Override
            public void close() throws IOException {
                sampleStream.close();
            }
        };
        monitor.startAndPrintThroughput();
        try {
            evaluator.evaluate(measuredSampleStream);
        }
        catch (IOException e) {
            System.err.println("failed");
            System.err.println("Reading test data error " + e.getMessage());
            throw new TerminateToolException(-1);
        }
        finally {
            try {
                measuredSampleStream.close();
            }
            catch (IOException e) {}
        }
        monitor.stopAndPrintFinalResult();
        System.out.println();
        System.out.println(evaluator.getFMeasure());
    }

    static interface Parameters {
        @ArgumentParser.ParameterDescription(valueName="charsetName")
        @ArgumentParser.OptionalParameter(defaultValue="UTF-8")
        public String getEncoding();

        @ArgumentParser.ParameterDescription(valueName="model")
        public String getModel();

        @ArgumentParser.ParameterDescription(valueName="data")
        public String getData();
    }
}

