/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class ExtendedJComboBox
extends JComboBox {
    private static final long serialVersionUID = 8320969518243948543L;
    private int preferredWidth = -1;
    private int minimumWidth = -1;
    private boolean layingOut = false;
    private boolean wide = true;

    public ExtendedJComboBox() {
        this(-1, -1);
    }

    public ExtendedJComboBox(int preferredWidth) {
        this(preferredWidth, -1);
    }

    public ExtendedJComboBox(int preferredWidth, int minimumWidth) {
        this(preferredWidth, minimumWidth, true);
    }

    public ExtendedJComboBox(int preferredWidth, int minimumWidth, boolean wide) {
        this.preferredWidth = preferredWidth;
        this.minimumWidth = minimumWidth;
        this.wide = wide;
        this.setRenderer(new ExtendedComboBoxRenderer());
    }

    public boolean isWide() {
        return this.wide;
    }

    public void setWide(boolean wide) {
        this.wide = wide;
    }

    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        if (this.preferredWidth != -1) {
            if ((double)this.preferredWidth < dim.getWidth()) {
                return new Dimension(this.preferredWidth, (int)dim.getHeight());
            }
            return dim;
        }
        return dim;
    }

    public Dimension getMinimumSize() {
        Dimension dim = super.getMinimumSize();
        if (this.minimumWidth != -1) {
            if ((double)this.minimumWidth < dim.getWidth()) {
                return new Dimension(this.minimumWidth, (int)dim.getHeight());
            }
            return dim;
        }
        return dim;
    }

    public void doLayout() {
        try {
            this.layingOut = true;
            super.doLayout();
        }
        finally {
            this.layingOut = false;
        }
    }

    public Dimension getSize() {
        Dimension dim = super.getSize();
        if (!this.layingOut && this.isWide()) {
            dim.width = Math.max(dim.width, super.getPreferredSize().width);
        }
        dim.width = Math.min(dim.width, Toolkit.getDefaultToolkit().getScreenSize().width - 40);
        return dim;
    }

    private static class ExtendedComboBoxRenderer
    extends BasicComboBoxRenderer {
        private static final long serialVersionUID = -6192190927539294311L;

        private ExtendedComboBoxRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                if (index >= 0) {
                    list.setToolTipText(value == null ? null : value.toString());
                }
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }
}

