/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.SimplePredictionModel;

public class PolynomialRegressionModel
extends SimplePredictionModel {
    private static final long serialVersionUID = 5503523600824976254L;
    private String[] attributeConstructions;
    private double[][] coefficients;
    private double[][] degrees;
    private double offset;

    public PolynomialRegressionModel(ExampleSet exampleSet, double[][] coefficients, double[][] degrees, double offset) {
        super(exampleSet);
        this.attributeConstructions = Tools.getRegularAttributeConstructions(exampleSet);
        this.coefficients = coefficients;
        this.degrees = degrees;
        this.offset = offset;
    }

    public double predict(Example example) throws OperatorException {
        return PolynomialRegressionModel.calculatePrediction(example, this.coefficients, this.degrees, this.offset);
    }

    public static double calculatePrediction(Example example, double[][] coefficients, double[][] degrees, double offset) {
        double prediction = 0.0;
        int index = 0;
        for (Attribute attribute : example.getAttributes()) {
            double value = example.getValue(attribute);
            int f = 0;
            while (f < coefficients.length) {
                prediction += coefficients[f][index] * Math.pow(value, degrees[f][index]);
                ++f;
            }
            ++index;
        }
        return prediction += offset;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        int index = 0;
        int i = 0;
        while (i < this.attributeConstructions.length) {
            int f = 0;
            while (f < this.coefficients.length) {
                result.append(String.valueOf(this.getCoefficientString(this.coefficients[f][index], first)) + " * " + this.attributeConstructions[i] + " ^ " + com.rapidminer.tools.Tools.formatNumber(this.degrees[f][i]) + com.rapidminer.tools.Tools.getLineSeparator());
                first = false;
                ++f;
            }
            ++index;
            ++i;
        }
        result.append(this.getCoefficientString(this.offset, first));
        return result.toString();
    }

    private String getCoefficientString(double coefficient, boolean first) {
        if (!first) {
            if (coefficient >= 0.0) {
                return "+ " + com.rapidminer.tools.Tools.formatNumber(Math.abs(coefficient));
            }
            return "- " + com.rapidminer.tools.Tools.formatNumber(Math.abs(coefficient));
        }
        if (coefficient >= 0.0) {
            return "  " + com.rapidminer.tools.Tools.formatNumber(Math.abs(coefficient));
        }
        return "- " + com.rapidminer.tools.Tools.formatNumber(Math.abs(coefficient));
    }
}

