/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.filter.NumericToNominal;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericToBinominal
extends NumericToNominal {
    public static final String PARAMETER_MIN = "min";
    public static final String PARAMETER_MAX = "max";

    public NumericToBinominal(OperatorDescription description) {
        super(description);
    }

    @Override
    protected void setValue(Example example, Attribute newAttribute, double value) throws OperatorException {
        double min = this.getParameterAsDouble(PARAMETER_MIN);
        double max = this.getParameterAsDouble(PARAMETER_MAX);
        if (Double.isNaN(value)) {
            example.setValue(newAttribute, Double.NaN);
        } else if (value < min || value > max) {
            example.setValue(newAttribute, newAttribute.getMapping().mapString("true"));
        } else {
            example.setValue(newAttribute, newAttribute.getMapping().mapString("false"));
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeDouble(PARAMETER_MIN, "The minimal value which is mapped to false (included).", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0));
        types.add(new ParameterTypeDouble(PARAMETER_MAX, "The maximal value which is mapped to false (included).", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0));
        return types;
    }

    @Override
    protected int getGeneratedAttributevalueType() {
        return 6;
    }

    @Override
    protected Attribute makeAttribute() {
        Attribute att = AttributeFactory.createAttribute(this.getGeneratedAttributevalueType());
        att.getMapping().mapString("false");
        att.getMapping().mapString("true");
        return att;
    }
}

