/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization.dependencies;

import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.viewer.ANOVAMatrixViewer;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.ResultObjectAdapter;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ANOVAMatrix
extends ResultObjectAdapter {
    private static final long serialVersionUID = 6245314851143584397L;
    private static final String RESULT_ICON_NAME = "table.png";
    private static Icon resultIcon = null;
    private double[][] probabilities;
    private List<String> anovaAttributeNames;
    private List<String> groupNames;
    private double significanceLevel;

    static {
        resultIcon = SwingTools.createIcon("16/table.png");
    }

    public ANOVAMatrix(double[][] probabilities, List<String> anovaAttributeNames, List<String> groupNames, double significanceLevel) {
        this.probabilities = probabilities;
        this.anovaAttributeNames = anovaAttributeNames;
        this.groupNames = groupNames;
        this.significanceLevel = significanceLevel;
    }

    public double[][] getProbabilities() {
        return this.probabilities;
    }

    public List<String> getAnovaAttributeNames() {
        return this.anovaAttributeNames;
    }

    public List<String> getGroupingAttributeNames() {
        return this.groupNames;
    }

    public double getSignificanceLevel() {
        return this.significanceLevel;
    }

    @Override
    public Component getVisualizationComponent(IOContainer container) {
        return new ANOVAMatrixViewer(this);
    }

    @Override
    public Icon getResultIcon() {
        return resultIcon;
    }

    @Override
    public String toResultString() {
        StringBuffer result = new StringBuffer();
        return result.toString();
    }

    public String toString() {
        return "ANOVA matrix indicating which attributes provide significant differences between groups defined by other (nominal) attributes.";
    }

    @Override
    public String getExtension() {
        return "ano";
    }

    @Override
    public String getFileDescription() {
        return "anova matrix";
    }
}

