/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.look.ui;

import com.rapidminer.gui.look.ClipboardActionsPopup;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextPaneUI;

public class TextPaneUI
extends BasicTextPaneUI {
    private ClipboardActionsPopup popup = null;
    private TextPanePopupListener popupListener = new TextPanePopupListener();

    public static ComponentUI createUI(JComponent c) {
        return new TextPaneUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.getComponent().addMouseListener(this.popupListener);
    }

    protected void uninstallDefaults() {
        super.installDefaults();
        this.getComponent().removeMouseListener(this.popupListener);
        this.popup = null;
    }

    public void update(Graphics g, JComponent c) {
        super.update(g, c);
    }

    private void showPopup(Point p) {
        if (!this.getComponent().isEnabled()) {
            return;
        }
        if (this.popup == null) {
            this.popup = new ClipboardActionsPopup(this.getComponent());
        }
        this.getComponent().requestFocus();
        this.popup.show(this.getComponent(), (int)p.getX(), (int)p.getY());
    }

    private class TextPanePopupListener
    extends MouseAdapter {
        private TextPanePopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.evaluateClick(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.evaluateClick(e);
        }

        private void evaluateClick(MouseEvent e) {
            if (e.isPopupTrigger()) {
                TextPaneUI.this.showPopup(e.getPoint());
            }
        }
    }
}

