/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter;

import com.rapidminer.ObjectVisualizer;
import com.rapidminer.datatable.DataTable;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.plotter.ScatterPlotter;
import com.rapidminer.gui.plotter.SimplePlotterPanelDialog;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class SimplePlotterDialog
extends JDialog
implements MouseMotionListener,
MouseListener {
    private static final long serialVersionUID = 3024071214549165747L;
    private ScatterPlotter plotter;
    private List<ObjectVisualizer> visualizers = new LinkedList<ObjectVisualizer>();
    private JButton createOtherPlottersButton = null;

    public SimplePlotterDialog(DataTable dataTable) {
        this(dataTable, true);
    }

    public SimplePlotterDialog(DataTable dataTable, boolean modal) {
        this(RapidMinerGUI.getMainFrame(), dataTable, -1, -1, false, modal);
    }

    public SimplePlotterDialog(Frame owner, final DataTable dataTable, int width, int height, boolean createPlotterPanelButton, boolean modal) {
        super(owner, dataTable.getName(), modal);
        this.setDefaultCloseOperation(2);
        this.plotter = new ScatterPlotter(dataTable);
        this.plotter.addMouseMotionListener(this);
        this.plotter.addMouseListener(this);
        JComponent plotterComponent = this.plotter.getPlotter();
        plotterComponent.setBorder(BorderFactory.createEtchedBorder());
        this.getContentPane().add((Component)plotterComponent, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        if (createPlotterPanelButton) {
            JButton createOtherPlottersButton = new JButton("Create other plotters...");
            createOtherPlottersButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SimplePlotterPanelDialog plotterPanelDialog = new SimplePlotterPanelDialog(dataTable);
                    plotterPanelDialog.setVisible(true);
                }
            });
            buttonPanel.add(createOtherPlottersButton);
        }
        if (this.plotter.isSaveable()) {
            JButton saveButton = new JButton("Save...");
            saveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SimplePlotterDialog.this.plotter.save();
                }
            });
            buttonPanel.add(saveButton);
        }
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimplePlotterDialog.this.ok();
            }
        });
        buttonPanel.add(okButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        if (width < 0 || height < 0) {
            this.setSize(600, 400);
        } else {
            this.setSize(width, height);
        }
        this.setLocationRelativeTo(owner);
    }

    public void setCreateOtherPlottersEnabled(boolean enabled) {
        if (this.createOtherPlottersButton != null) {
            this.createOtherPlottersButton.setEnabled(enabled);
        }
    }

    public void setDrawRange(double minX, double maxX, double minY, double maxY) {
        this.plotter.setDrawRange(minX, maxX, minY, maxY);
    }

    public void setXAxis(int index) {
        this.plotter.setAxis(0, index);
    }

    public void setYAxis(int index) {
        this.plotter.setAxis(1, index);
    }

    public void plotColumn(int index, boolean plot) {
        this.plotter.setPlotColumn(index, plot);
    }

    public void setPointType(int pointType) {
        this.plotter.setPointType(pointType);
    }

    public void setDrawLabel(boolean v) {
        this.plotter.setDrawLabel(v);
    }

    public void setKey(String key) {
        this.plotter.setKey(key);
    }

    private void ok() {
        this.dispose();
    }

    public void addObjectVisualizer(ObjectVisualizer visualizer) {
        this.visualizers.add(visualizer);
    }

    public void removeObjectVisualizer(ObjectVisualizer visualizer) {
        this.visualizers.remove(visualizer);
    }

    private void fireVisualizationEvent(String id) {
        for (ObjectVisualizer visualizer : this.visualizers) {
            if (!visualizer.isCapableToVisualize(id)) continue;
            visualizer.startVisualization(id);
        }
    }

    public void mouseMoved(MouseEvent e) {
        this.plotter.setMousePosInDataSpace(e.getX(), e.getY());
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        String id;
        if (e.getButton() == 1 && e.getClickCount() > 1 && (id = this.plotter.getIdForPos(e.getX(), e.getY())) != null) {
            this.fireVisualizationEvent(id);
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }
}

