/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.construction;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.generator.AbsoluteValueGenerator;
import com.rapidminer.generator.BasicArithmeticOperationGenerator;
import com.rapidminer.generator.ExponentialFunctionGenerator;
import com.rapidminer.generator.FeatureGenerator;
import com.rapidminer.generator.FloorCeilGenerator;
import com.rapidminer.generator.MinMaxGenerator;
import com.rapidminer.generator.PowerGenerator;
import com.rapidminer.generator.ReciprocalValueGenerator;
import com.rapidminer.generator.SquareRootGenerator;
import com.rapidminer.generator.TrigonometricFunctionGenerator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.construction.AbstractFeatureConstruction;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompleteFeatureGenerationOperator
extends AbstractFeatureConstruction {
    public static final String PARAMETER_KEEP_ALL = "keep_all";
    public static final String PARAMETER_USE_PLUS = "use_plus";
    public static final String PARAMETER_USE_DIFF = "use_diff";
    public static final String PARAMETER_USE_MULT = "use_mult";
    public static final String PARAMETER_USE_DIV = "use_div";
    public static final String PARAMETER_USE_RECIPROCALS = "use_reciprocals";
    public static final String PARAMETER_USE_SQUARE_ROOTS = "use_square_roots";
    public static final String PARAMETER_USE_POWER_FUNCTIONS = "use_power_functions";
    public static final String PARAMETER_USE_SIN = "use_sin";
    public static final String PARAMETER_USE_COS = "use_cos";
    public static final String PARAMETER_USE_TAN = "use_tan";
    public static final String PARAMETER_USE_ATAN = "use_atan";
    public static final String PARAMETER_USE_EXP = "use_exp";
    public static final String PARAMETER_USE_LOG = "use_log";
    public static final String PARAMETER_USE_ABSOLUTE_VALUES = "use_absolute_values";
    public static final String PARAMETER_USE_MIN = "use_min";
    public static final String PARAMETER_USE_MAX = "use_max";
    public static final String PARAMETER_USE_CEIL = "use_ceil";
    public static final String PARAMETER_USE_FLOOR = "use_floor";
    public static final String PARAMETER_USE_ROUNDED = "use_rounded";

    public CompleteFeatureGenerationOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        FeatureGenerator.setSelectionMode(1);
        List<FeatureGenerator> generators = this.getGenerators();
        LinkedList<FeatureGenerator> generatorList = new LinkedList<FeatureGenerator>();
        for (FeatureGenerator generator : generators) {
            List<Attribute[]> inputAttributes = generator.getInputCandidates(exampleSet, new String[0]);
            for (Attribute[] args : inputAttributes) {
                FeatureGenerator newGenerator = generator.newInstance();
                newGenerator.setArguments(args);
                generatorList.add(newGenerator);
            }
        }
        if (!this.getParameterAsBoolean(PARAMETER_KEEP_ALL)) {
            exampleSet.getAttributes().clearRegular();
        }
        List<Attribute> newAttributes = FeatureGenerator.generateAll(exampleSet.getExampleTable(), generatorList);
        for (Attribute newAttribute : newAttributes) {
            exampleSet.getAttributes().addRegular(newAttribute);
        }
        return exampleSet;
    }

    private List<FeatureGenerator> getGenerators() {
        ArrayList<FeatureGenerator> generators = new ArrayList<FeatureGenerator>();
        if (this.getParameterAsBoolean(PARAMETER_USE_PLUS)) {
            generators.add(new BasicArithmeticOperationGenerator(0));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_DIFF)) {
            generators.add(new BasicArithmeticOperationGenerator(1));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_MULT)) {
            generators.add(new BasicArithmeticOperationGenerator(2));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_DIV)) {
            generators.add(new BasicArithmeticOperationGenerator(3));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_RECIPROCALS)) {
            generators.add(new ReciprocalValueGenerator());
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_SQUARE_ROOTS)) {
            generators.add(new SquareRootGenerator());
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_POWER_FUNCTIONS)) {
            generators.add(new PowerGenerator());
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_SIN)) {
            generators.add(new TrigonometricFunctionGenerator(0));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_COS)) {
            generators.add(new TrigonometricFunctionGenerator(1));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_TAN)) {
            generators.add(new TrigonometricFunctionGenerator(2));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_ATAN)) {
            generators.add(new TrigonometricFunctionGenerator(3));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_EXP)) {
            generators.add(new ExponentialFunctionGenerator(0));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_LOG)) {
            generators.add(new ExponentialFunctionGenerator(1));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_ABSOLUTE_VALUES)) {
            generators.add(new AbsoluteValueGenerator());
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_MIN)) {
            generators.add(new MinMaxGenerator(0));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_MAX)) {
            generators.add(new MinMaxGenerator(1));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_CEIL)) {
            generators.add(new FloorCeilGenerator(1));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_FLOOR)) {
            generators.add(new FloorCeilGenerator(0));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_ROUNDED)) {
            generators.add(new FloorCeilGenerator(2));
        }
        return generators;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_KEEP_ALL, "If set to true, all the original attributes are kept, otherwise they are removed from the example set.", true));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_PLUS, "Generate sums.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_DIFF, "Generate differences.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_MULT, "Generate products.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_DIV, "Generate quotients.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_RECIPROCALS, "Generate reciprocal values.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_SQUARE_ROOTS, "Generate square root values.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_POWER_FUNCTIONS, "Generate the power of one attribute and another.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_SIN, "Generate sinus.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_COS, "Generate cosinus.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_TAN, "Generate tangens.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_ATAN, "Generate arc tangens.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_EXP, "Generate exponential functions.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_LOG, "Generate logarithmic functions.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_ABSOLUTE_VALUES, "Generate absolute values.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_MIN, "Generate minimum values.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_MAX, "Generate maximum values.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_CEIL, "Generate ceil values.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_FLOOR, "Generate floor values.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_ROUNDED, "Generate rounded values.", false));
        return types;
    }
}

