/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.weighting;

import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWeighting
extends Operator {
    public static final String PARAMETER_NORMALIZE_WEIGHTS = "normalize_weights";

    public AbstractWeighting(OperatorDescription description) {
        super(description);
    }

    public abstract AttributeWeights calculateWeights(ExampleSet var1) throws OperatorException;

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        AttributeWeights weights = this.calculateWeights(exampleSet);
        if (this.getParameterAsBoolean(PARAMETER_NORMALIZE_WEIGHTS)) {
            weights.normalize();
        }
        return new IOObject[]{exampleSet, weights};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class, AttributeWeights.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> list = super.getParameterTypes();
        list.add(new ParameterTypeBoolean(PARAMETER_NORMALIZE_WEIGHTS, "Activates the normalization of all weights.", true));
        return list;
    }
}

