/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.weighting;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.weighting.AbstractWeighting;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardDeviationWeighting
extends AbstractWeighting {
    public static final String PARAMETER_NORMALIZE = "normalize";
    private static final String[] NORMALIZATIONS = new String[]{"none", "average", "minimum", "maximum"};
    private static final int NONE = 0;
    private static final int AVERAGE = 1;
    private static final int MINIMUM = 2;
    private static final int MAXIMUM = 3;

    public StandardDeviationWeighting(OperatorDescription description) {
        super(description);
    }

    @Override
    public AttributeWeights calculateWeights(ExampleSet exampleSet) throws OperatorException {
        exampleSet.recalculateAllAttributeStatistics();
        int normalization = this.getParameterAsInt(PARAMETER_NORMALIZE);
        AttributeWeights weights = new AttributeWeights();
        for (Attribute attribute : exampleSet.getAttributes()) {
            double data = Math.sqrt(exampleSet.getStatistics(attribute, "variance"));
            switch (normalization) {
                case 0: {
                    break;
                }
                case 1: {
                    data /= exampleSet.getStatistics(attribute, "average");
                    break;
                }
                case 2: {
                    data /= exampleSet.getStatistics(attribute, "minimum");
                    break;
                }
                case 3: {
                    data /= exampleSet.getStatistics(attribute, "maximum");
                    break;
                }
            }
            data = Math.abs(data);
            weights.setWeight(attribute.getName(), data);
        }
        return weights;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeCategory type = new ParameterTypeCategory(PARAMETER_NORMALIZE, "Indicates if the standard deviation should be divided by the minimum, maximum, or average of the attribute.", NORMALIZATIONS, 0);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

