/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.generator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.generator.TargetFunction;
import com.rapidminer.tools.RandomGenerator;

public class GridFunction
implements TargetFunction {
    private double lowerBound = -10.0;
    private double upperBound = 10.0;
    private int numberOfExamples;
    private int numberOfAttributes;
    private int[] counter;
    private int maxCounter;
    private double dimDistance;

    public void init(RandomGenerator random) {
        this.counter = new int[this.numberOfAttributes];
        this.maxCounter = (int)Math.round(Math.exp(Math.log(this.numberOfExamples) / (double)this.numberOfAttributes));
        this.dimDistance = (this.upperBound - this.lowerBound) / (double)this.maxCounter;
    }

    public void setTotalNumberOfExamples(int number) {
        this.numberOfExamples = number;
    }

    public void setTotalNumberOfAttributes(int number) {
        this.numberOfAttributes = number;
    }

    public void setLowerArgumentBound(double lower) {
        this.lowerBound = lower;
    }

    public void setUpperArgumentBound(double upper) {
        this.upperBound = upper;
    }

    public Attribute getLabel() {
        return AttributeFactory.createAttribute("label", 4);
    }

    public double calculate(double[] att) throws TargetFunction.FunctionException {
        return 0.0;
    }

    public double[] createArguments(int number, RandomGenerator random) throws TargetFunction.FunctionException {
        if (number <= 0) {
            throw new TargetFunction.FunctionException("Grid function", "must have at least one attribute!");
        }
        double[] args = new double[number];
        int i = 0;
        while (i < args.length) {
            args[i] = this.lowerBound + this.dimDistance / 2.0 + (double)this.counter[i] * this.dimDistance;
            ++i;
        }
        this.incrementCounter(this.counter, 0);
        return args;
    }

    private void incrementCounter(int[] counter, int pos) {
        int n = pos;
        counter[n] = counter[n] + 1;
        if (counter[pos] >= this.maxCounter) {
            counter[pos] = 0;
            if (pos < counter.length - 1) {
                this.incrementCounter(counter, pos + 1);
            }
        }
    }
}

