/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.igss.utility;

import com.rapidminer.operator.learner.igss.hypothesis.Hypothesis;
import com.rapidminer.operator.learner.igss.utility.AbstractUtility;
import com.rapidminer.operator.learner.igss.utility.Coverage;

public class Linear
extends AbstractUtility {
    public Linear(double[] priors, int large) {
        super(priors, large);
    }

    public double utility(double totalWeight, double totalPositiveWeight, Hypothesis hypo) {
        double g = hypo.getCoveredWeight() / totalWeight;
        double p = hypo.getPositiveWeight() / hypo.getCoveredWeight();
        if (hypo.getPrediction() == 1) {
            return g * (p - this.priors[1]);
        }
        return g * (p - this.priors[0]);
    }

    public double conf(double totalExampleWeight, double delta) {
        double inverseNormal = this.inverseNormal(1.0 - delta / 4.0);
        return inverseNormal / Math.sqrt(totalExampleWeight) + Math.pow(inverseNormal, 2.0) / (4.0 * totalExampleWeight);
    }

    public double conf(double totalExampleWeight, double totalPositiveWeight, Hypothesis hypo, double delta) {
        double g = hypo.getCoveredWeight() / totalExampleWeight;
        double p = hypo.getPositiveWeight() / hypo.getCoveredWeight();
        double sg = this.variance(g, totalExampleWeight);
        double sp = this.variance(p, hypo.getCoveredWeight());
        double inverseNormal = this.inverseNormal(1.0 - delta / 4.0);
        return inverseNormal * (sg + sp + inverseNormal * sg * sp);
    }

    private double variance(double p, double totalExampleWeight) {
        return p * (1.0 - p) / totalExampleWeight;
    }

    public double confSmallM(double totalExampleWeight, double delta) {
        return 3.0 * Math.sqrt(Math.log(4.0 / delta) / (2.0 * totalExampleWeight));
    }

    public double getUpperBound(double totalWeight, double totalPositiveWeight, Hypothesis hypo, double delta) {
        double p0 = hypo.getPrediction() == 1 ? this.priors[1] : this.priors[0];
        Coverage cov = new Coverage(this.priors, this.large);
        Hypothesis h = hypo.clone();
        h.setCoveredWeight(hypo.getPositiveWeight());
        double g = cov.utility(totalWeight, totalPositiveWeight, h);
        double conf = cov.confidenceIntervall(totalWeight, delta);
        return (g + conf) * (1.0 - p0);
    }
}

