/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.weka;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.WekaTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToolBar;
import weka.classifiers.Classifier;
import weka.classifiers.UpdateableClassifier;
import weka.core.Drawable;
import weka.core.Instance;
import weka.core.Instances;
import weka.gui.graphvisualizer.GraphVisualizer;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeDisplayEvent;
import weka.gui.treevisualizer.TreeDisplayListener;
import weka.gui.treevisualizer.TreeVisualizer;

public class WekaClassifier
extends PredictionModel {
    private static final long serialVersionUID = -2684252543419537079L;
    private Classifier classifier;
    private String name;

    public WekaClassifier(ExampleSet exampleSet, String name, Classifier classifier) {
        super(exampleSet);
        this.name = name;
        this.classifier = classifier;
    }

    public Classifier getClassifier() {
        return this.classifier;
    }

    public boolean isUpdatable() {
        return this.classifier instanceof UpdateableClassifier;
    }

    public void updateModel(ExampleSet updateExampleSet) throws OperatorException {
        if (!(this.classifier instanceof UpdateableClassifier)) {
            throw new UserError(null, 135, String.valueOf(this.getClass().getName()) + " (" + this.classifier.getClass() + ")");
        }
        UpdateableClassifier updateableClassifier = (UpdateableClassifier)this.classifier;
        this.updateClassifier(updateableClassifier, updateExampleSet);
    }

    private void updateClassifier(UpdateableClassifier classifier, ExampleSet exampleSet) throws OperatorException {
        this.log("Update Weka classifier.");
        this.log("Converting to Weka instances.");
        Instances instances = WekaTools.toWekaInstances(exampleSet, "UpdateInstances", 0);
        this.log("Actually updating Weka classifier.");
        try {
            int i = 0;
            while (i < instances.numInstances()) {
                Instance instance = instances.instance(i);
                classifier.updateClassifier(instance);
                ++i;
            }
        }
        catch (Exception e) {
            throw new UserError(null, 310, "updating Weka model", e.getMessage());
        }
    }

    public ExampleSet performPrediction(ExampleSet exampleSet, Attribute predictedLabel) throws OperatorException {
        this.log("Applying Weka classifier.");
        this.log("Converting to Weka instances.");
        Instances instances = WekaTools.toWekaInstances(exampleSet, "ApplierInstances", 1);
        this.log("Actually applying Weka classifier.");
        int i = 0;
        for (Example e : exampleSet) {
            Instance instance = instances.instance(i++);
            this.applyModelForInstance(instance, e, predictedLabel);
        }
        return exampleSet;
    }

    public void applyModelForInstance(Instance instance, Example e, Attribute predictedLabelAttribute) {
        double predictedLabel = Double.NaN;
        try {
            double wekaPrediction = this.classifier.classifyInstance(instance);
            if (predictedLabelAttribute.isNominal()) {
                double[] confidences = this.classifier.distributionForInstance(instance);
                int i = 0;
                while (i < confidences.length) {
                    String classification = instance.classAttribute().value(i);
                    e.setConfidence(classification, confidences[i]);
                    ++i;
                }
                String classification = instance.classAttribute().value((int)wekaPrediction);
                predictedLabel = predictedLabelAttribute.getMapping().mapString(classification);
            } else {
                predictedLabel = this.classifier.classifyInstance(instance);
            }
        }
        catch (Exception exc) {
            this.logError("Exception occured while classifying example:" + exc.getMessage() + " [" + exc.getClass() + "]");
        }
        e.setValue(predictedLabelAttribute, predictedLabel);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.valueOf(this.name) + " (model for label " + this.getLabel() + ")" + Tools.getLineSeparator() + this.classifier.toString();
    }

    public String toResultString() {
        return this.classifier.toString();
    }

    private Component createTextAndGraphView(final Component textView, final Component graphView) {
        final JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        final JRadioButton graphViewButton = new JRadioButton("Graph View", true);
        graphViewButton.setToolTipText("Changes to a graphical view of this model.");
        graphViewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (graphViewButton.isSelected()) {
                    mainPanel.remove(1);
                    mainPanel.add(graphView, "Center");
                    mainPanel.repaint();
                }
            }
        });
        final JRadioButton textViewButton = new JRadioButton("Text View", true);
        textViewButton.setToolTipText("Changes to a textual view of this model.");
        textViewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (textViewButton.isSelected()) {
                    mainPanel.remove(1);
                    mainPanel.add(textView, "Center");
                    mainPanel.repaint();
                }
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(textViewButton);
        group.add(graphViewButton);
        JPanel togglePanel = new JPanel(new FlowLayout(0));
        togglePanel.add(textViewButton);
        togglePanel.add(graphViewButton);
        mainPanel.add((Component)togglePanel, "North");
        mainPanel.add(graphView, "Center");
        graphViewButton.setSelected(true);
        return mainPanel;
    }

    public Component getVisualizationComponent(IOContainer container) {
        if (this.classifier instanceof Drawable) {
            try {
                Drawable drawable = (Drawable)this.classifier;
                int graphType = drawable.graphType();
                switch (graphType) {
                    case 1: {
                        TreeVisualizer treeView = new TreeVisualizer(new TreeDisplayListener(){

                            public void userCommand(TreeDisplayEvent e) {
                            }
                        }, drawable.graph(), (NodePlace)new PlaceNode2());
                        return this.createTextAndGraphView(super.getVisualizationComponent(container), (Component)treeView);
                    }
                    case 2: {
                        GraphVisualizer visualizer = new GraphVisualizer();
                        JToolBar graphTools = (JToolBar)visualizer.getComponent(0);
                        visualizer.remove((Component)graphTools);
                        graphTools.remove(graphTools.getComponentCount() - 1);
                        JPanel toolPanel = new JPanel(new BorderLayout());
                        toolPanel.add((Component)graphTools, "North");
                        visualizer.add((Component)toolPanel, (Object)"West");
                        visualizer.readBIF(drawable.graph());
                        visualizer.layoutGraph();
                        return this.createTextAndGraphView(super.getVisualizationComponent(container), (Component)visualizer);
                    }
                }
                return super.getVisualizationComponent(container);
            }
            catch (Exception e) {
                return super.getVisualizationComponent(container);
            }
        }
        return super.getVisualizationComponent(container);
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        WekaClassifier other = (WekaClassifier)o;
        return other.classifier.equals(this.classifier);
    }

    public int hashCode() {
        return this.classifier.hashCode();
    }
}

