/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.transformer;

import com.rapidminer.operator.AbstractTokenProcessor;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import edu.udo.cs.wvtool.main.WVTDocumentInfo;
import edu.udo.cs.wvtool.util.TokenEnumeration;
import edu.udo.cs.wvtool.util.TokenEnumerationAdapter;
import edu.udo.cs.wvtool.util.WVToolException;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenReplace
extends AbstractTokenProcessor {
    public static final String PARAMETER_REPLACE_DICTIONARY = "replace_dictionary";
    public static final String PARAMETER_REPLACE_BY = "replace_by";

    public TokenReplace(OperatorDescription description) {
        super(description);
    }

    @Override
    protected TokenEnumeration process(TokenEnumeration tokens, WVTDocumentInfo docInfo) throws WVToolException {
        List<String[]> dictionary;
        try {
            dictionary = this.getParameterList(PARAMETER_REPLACE_DICTIONARY);
        }
        catch (UndefinedParameterError e1) {
            throw new WVToolException("This operator needs a dictionary. Please specify.", (Throwable)e1);
        }
        int dictionarySize = dictionary.size();
        if (dictionarySize > 0) {
            Pattern[] replaceWhatPattern = new Pattern[dictionarySize];
            String[] replaceByString = new String[dictionarySize];
            int i = 0;
            for (String[] replacement : dictionary) {
                String regex = replacement[0];
                replaceByString[i] = replacement[1];
                try {
                    replaceWhatPattern[i] = Pattern.compile(regex);
                }
                catch (PatternSyntaxException e) {
                    throw new WVToolException("Dictionary entry no valid regular expression: " + regex, (Throwable)new UserError((Operator)this, 206, regex, e.getMessage()));
                }
                ++i;
            }
            LinkedList<String> tokenList = new LinkedList<String>();
            while (tokens.hasMoreTokens()) {
                String currentToken = tokens.nextToken();
                i = 0;
                while (i < dictionarySize) {
                    Matcher whatMatcher = replaceWhatPattern[i].matcher(currentToken);
                    tokenList.add(whatMatcher.replaceAll(replaceByString[i]));
                    ++i;
                }
            }
            return new TokenEnumerationAdapter(tokenList);
        }
        return tokens;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeList type = new ParameterTypeList(PARAMETER_REPLACE_DICTIONARY, "Defines the replacements.", new ParameterTypeString(PARAMETER_REPLACE_BY, "Defines what should be replaced"));
        types.add(type);
        return types;
    }
}

