/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.dictionary.morph;

import java.util.ArrayList;
import java.util.List;
import net.didion.jwnl.JWNLRuntimeException;

public class BaseFormSet {
    private List _forms = new ArrayList();
    private int _index = -1;
    private boolean _allowDuplicates;

    public BaseFormSet() {
        this(false);
    }

    public BaseFormSet(boolean allowDuplicates) {
        this._allowDuplicates = allowDuplicates;
    }

    public void add(String s) {
        if (this._allowDuplicates || !this._forms.contains(s)) {
            this._forms.add(s);
        }
    }

    public void addAll(BaseFormSet forms) {
        if (this._allowDuplicates) {
            this._forms.addAll(forms._forms);
        } else {
            int i = 0;
            while (i < forms._forms.size()) {
                this.add((String)forms._forms.get(i));
                ++i;
            }
        }
    }

    public String getForm(int index) {
        if (!this.isFormAvailable(index)) {
            throw new IllegalArgumentException(String.valueOf(index));
        }
        return (String)this._forms.get(index);
    }

    public List getForms() {
        return this._forms;
    }

    public boolean isCurrentFormAvailable() {
        return this.isFormAvailable(this._index);
    }

    public String getCurrentForm() {
        if (!this.isCurrentFormAvailable()) {
            throw new JWNLRuntimeException("DICTIONARY_EXCEPTION_012");
        }
        return this.getForm(this._index);
    }

    public boolean isMoreFormsAvailable() {
        return this.isFormAvailable(this._index + 1);
    }

    public String getNextForm() {
        if (!this.isMoreFormsAvailable()) {
            throw new JWNLRuntimeException("DICTIONARY_EXCEPTION_013");
        }
        return this.getForm(++this._index);
    }

    public int getIndex() {
        return this._index;
    }

    public void setIndex(int index) {
        if (index < this._forms.size()) {
            this._index = index;
        }
    }

    public int size() {
        return this._forms.size();
    }

    private boolean isFormAvailable(int index) {
        return index >= 0 && index < this._forms.size();
    }
}

