/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.look.fc;

import com.rapidminer.gui.look.fc.Bookmark;
import com.rapidminer.gui.look.fc.BookmarkDialog;
import com.rapidminer.gui.look.fc.BookmarkIO;
import com.rapidminer.gui.look.fc.BookmarkList;
import com.rapidminer.gui.look.fc.BookmarkListModel;
import com.rapidminer.gui.look.fc.FileChooserUI;
import com.rapidminer.gui.look.fc.FileTable;
import com.rapidminer.gui.look.fc.FileTableLabel;
import com.rapidminer.gui.look.fc.Item;
import com.rapidminer.gui.look.fc.ItemPanel;
import com.rapidminer.gui.look.fc.ItemPanelKeyboardListener;
import com.rapidminer.gui.look.fc.ThumbGeneratorThread;
import com.rapidminer.gui.look.fc.Tools;
import com.rapidminer.gui.tools.SwingTools;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.filechooser.FileSystemView;
import sun.awt.shell.ShellFolder;

public class FileList
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 8893252970970228545L;
    private static final ImageIcon SMALL_FILE_IMAGE = SwingTools.createImage("plaf/unknown_file_small.png");
    private static final ImageIcon SMALL_FOLDER_IMAGE = SwingTools.createImage("plaf/unknown_folder_small.png");
    private static final ImageIcon BIG_FILE_IMAGE = SwingTools.createImage("plaf/unknown_file_big.png");
    private static final ImageIcon BIG_FOLDER_IMAGE = SwingTools.createImage("plaf/unknown_folder_big.png");
    private File selectedFile;
    private Cursor waitCursor = Cursor.getPredefinedCursor(3);
    private Cursor normalCursor = Cursor.getPredefinedCursor(0);
    private ButtonGroup viewButtonGroup;
    private ButtonGroup orderButtonGroup;
    protected ItemPanel itemPanel = new ItemPanel(this);
    private ThumbGeneratorThread thumbGenerator = new ThumbGeneratorThread(this.itemPanel);
    private FileSystemView fsv = FileSystemView.getFileSystemView();
    private BookmarkIO bookmarksIO = new BookmarkIO();
    private BookmarkListModel bookmarkListModel = new BookmarkListModel();
    private JList bookmarkList = new BookmarkList(this.bookmarkListModel, this);
    private JSplitPane mainSplitPane = new JSplitPane();
    private JMenuItem menuItem;
    private Window window;
    protected JPanel cardPanel = new JPanel(new CardLayout());
    private JScrollPane tableScrollPane = new JScrollPane();
    protected FileTable tablePanel = new FileTable(this);
    protected JScrollPane browseScrollPane = new JScrollPane();
    private TreeMap<String, Object[]> systemInfoCach = new TreeMap();
    protected ItemPanelKeyboardListener keyListener = new ItemPanelKeyboardListener();
    protected Vector<Object> completeItemsList = new Vector(20);
    protected Vector<Item> visibleItemsList = new Vector(20);
    protected Vector<Object> tempList = new Vector(20);
    private TreeMap<Item, Item> tempCompareTree = new TreeMap();
    protected Item lastSelected;
    protected JPopupMenu panePopup;
    private MenuListener mal;
    private String tempExtension;
    protected JFileChooser fc;
    protected FileChooserUI filechooserUI;
    protected File tempFile;
    protected File currentFile = null;
    private Object[] tempArray;
    private File[] selectedFilesArray;
    protected Vector<Object> selectedFilesVector = new Vector();
    private boolean tempFlag = false;
    public static String ORDER_BY_FILE_NAME = "Name";
    public static String ORDER_BY_FILE_TYPE = "File type";
    public static String ORDER_BY_FILE_MODIFIED = "Last modified";
    public static String ORDER_BY_FILE_SIZE = "File size";
    protected String ORDER_BY = ORDER_BY_FILE_NAME;
    private JMenuItem addToBookmarksMenuItem;
    private JCheckBoxMenuItem autoArrangeCheckBox;

    public FileList() {
        this.bookmarkList.setSelectionMode(0);
        this.bookmarkList.setLayoutOrientation(0);
        this.bookmarkList.setVisibleRowCount(-1);
    }

    protected ImageIcon getSystemIcon(File file, String filename, boolean isDir, boolean bigIcon) throws Exception {
        if (!isDir) {
            this.tempExtension = filename.indexOf(46) > -1 ? filename.substring(1 + file.getName().indexOf(46)) : "Type is : ." + this.fsv.getSystemTypeDescription(file);
            if (this.systemInfoCach.containsKey(this.tempExtension)) {
                this.cachSystemDetails(file, filename);
            }
            this.tempArray = this.systemInfoCach.get(this.tempExtension);
            if (bigIcon) {
                if (this.tempArray[3] == null) {
                    Image image = this.getShellFolder(file).getIcon(true);
                    this.tempArray[3] = image == null ? BIG_FILE_IMAGE : Tools.getBigSystemIcon(image);
                    this.systemInfoCach.put(this.tempExtension, this.tempArray);
                }
                return (ImageIcon)this.tempArray[3];
            }
            if (this.tempArray[2] == null) {
                Image image = null;
                try {
                    image = this.getShellFolder(file).getIcon(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.tempArray[2] = image == null ? SMALL_FILE_IMAGE : Tools.getSmallSystemIcon(image);
                this.systemInfoCach.put(this.tempExtension, this.tempArray);
            }
            return (ImageIcon)this.tempArray[2];
        }
        if (bigIcon) {
            Image image = this.getShellFolder(file).getIcon(true);
            if (image == null) {
                return BIG_FOLDER_IMAGE;
            }
            return Tools.getBigSystemIcon(image);
        }
        Image tempImage = this.getShellFolder(file).getIcon(false);
        if (tempImage == null) {
            return SMALL_FOLDER_IMAGE;
        }
        return Tools.getSmallSystemIcon(tempImage);
    }

    private void updateViewMenuItemsGroup() {
        Enumeration<AbstractButton> en = this.viewButtonGroup.getElements();
        while (en.hasMoreElements()) {
            JRadioButtonMenuItem rbm = (JRadioButtonMenuItem)en.nextElement();
            if (!rbm.getActionCommand().equals("viewType:" + this.filechooserUI.getView())) continue;
            this.viewButtonGroup.setSelected(rbm.getModel(), true);
        }
    }

    protected void changeCardForView() {
        this.stopTumbnailGeneration();
        if (this.filechooserUI.getView().equals("Details")) {
            CardLayout cl = (CardLayout)this.cardPanel.getLayout();
            cl.show(this.cardPanel, "tableScrollPane");
            this.updateTableData();
            this.tableScrollPane.getViewport().setViewPosition(new Point());
            this.tablePanel.requestFocusInWindow();
        } else {
            CardLayout cl = (CardLayout)this.cardPanel.getLayout();
            cl.show(this.cardPanel, "browseScrollPane");
            this.itemPanel.updateViewType();
            this.browseScrollPane.getViewport().setViewPosition(new Point());
            this.itemPanel.requestFocusInWindow();
        }
        this.updateViewMenuItemsGroup();
    }

    protected Object[] cachSystemDetails(File file, String filename) {
        this.tempExtension = filename.indexOf(46) > -1 ? filename.substring(1 + file.getName().indexOf(46)) : "Type is : ." + this.fsv.getSystemTypeDescription(file);
        if (!this.systemInfoCach.containsKey(this.tempExtension)) {
            try {
                String tempDesc = null;
                try {
                    tempDesc = this.fsv.getSystemTypeDescription(file);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (tempDesc == null) {
                    tempDesc = filename;
                }
                Object[] objectArray = new Object[4];
                objectArray[0] = this.tempExtension;
                objectArray[1] = tempDesc;
                this.systemInfoCach.put(this.tempExtension, objectArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.systemInfoCach.get(this.tempExtension);
    }

    private ShellFolder getShellFolder(File f) {
        try {
            return ShellFolder.getShellFolder(f);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (InternalError e) {
            return null;
        }
    }

    public void addToBookmarks() {
        this.addToBookmarks(this.fc.getCurrentDirectory());
    }

    public void addToBookmarks(File f) {
        String name = "";
        name = JOptionPane.showInputDialog(this.fc, "Please insert preferred name for selected folder", this.fsv.getSystemDisplayName(f));
        if (name != null && !name.trim().equals("")) {
            try {
                this.bookmarksIO.addToList(name, f.getCanonicalFile().getPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.updateBookmarks();
        }
    }

    private void updateBookmarks() {
        this.bookmarkListModel.removeAllBookmarks();
        Collection<Bookmark> bookmarks = this.bookmarksIO.getBookmarks();
        for (Bookmark bookmark : bookmarks) {
            this.bookmarkListModel.addBookmark(bookmark);
        }
    }

    public void deleteBookmark(Bookmark bookmark) {
        this.bookmarksIO.deleteBookmark(bookmark);
        this.updateBookmarks();
    }

    public void renameBookmark(Bookmark bookmark) {
        this.window = Tools.getWindowForComponent(this);
        BookmarkDialog dialog = this.window instanceof Frame ? new BookmarkDialog((Frame)this.window, true) : new BookmarkDialog((Dialog)this.window, true);
        dialog.setLocationRelativeTo(this.window);
        dialog.updateDefaults(bookmark.getName(), bookmark.getPath());
        dialog.setVisible(true);
        if (dialog.isNameChanged()) {
            this.bookmarksIO.renameBookmark(bookmark, dialog.getNewName());
            this.updateBookmarks();
        }
    }

    public File getFile() {
        return this.selectedFile;
    }

    public FileList(FileChooserUI tfcui, JFileChooser fc) {
        try {
            this.fc = fc;
            this.filechooserUI = tfcui;
            this.init();
            this.updateBookmarks();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void init() throws Exception {
        this.setLayout(new BorderLayout());
        this.mainSplitPane.setName("");
        this.mainSplitPane.setAutoscrolls(true);
        this.mainSplitPane.setBorder(null);
        this.mainSplitPane.setMinimumSize(new Dimension(40, 25));
        this.mainSplitPane.setOpaque(true);
        this.mainSplitPane.setContinuousLayout(false);
        this.mainSplitPane.setDividerLocation(170);
        this.mainSplitPane.setLastDividerLocation(170);
        this.mainSplitPane.setOneTouchExpandable(true);
        this.tableScrollPane.getViewport().setBackground(Color.white);
        this.tableScrollPane.setFocusable(false);
        this.tableScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.browseScrollPane.setName("");
        this.browseScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        JScrollPane bookmarkPane = new JScrollPane(this.bookmarkList);
        bookmarkPane.setBorder(BorderFactory.createTitledBorder("Bookmarks"));
        this.add((Component)this.mainSplitPane, "Center");
        this.cardPanel.add((Component)this.browseScrollPane, "browseScrollPane");
        this.browseScrollPane.setActionMap(null);
        this.cardPanel.add((Component)this.tableScrollPane, "tableScrollPane");
        this.tableScrollPane.setActionMap(null);
        this.tableScrollPane.getViewport().add(this.tablePanel);
        this.browseScrollPane.getViewport().add(this.itemPanel);
        this.mainSplitPane.add((Component)this.cardPanel, "right");
        this.mainSplitPane.add((Component)bookmarkPane, "left");
        this.fc.setPreferredSize(new Dimension(780, 510));
        this.updateTablePanelSize();
        this.cardPanel.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                FileList.this.itemPanel.arrangeTheFiles((int)FileList.this.cardPanel.getSize().getWidth());
            }
        });
        this.tableScrollPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                FileList.this.updateTablePanelSize();
                if (FileList.this.filechooserUI.viewType.equals("Details")) {
                    FileList.this.tablePanel.requestFocusInWindow();
                }
            }
        });
    }

    protected void updateTablePanelSize() {
        if ((double)this.tablePanel.getInitialHeight() < this.tableScrollPane.getSize().getHeight()) {
            this.tablePanel.setPreferredSize(new Dimension(this.tablePanel.getWidth(), this.tableScrollPane.getHeight() - this.tablePanel.getTableHeader().getHeight()));
            this.tablePanel.setMinimumSize(this.tablePanel.getPreferredSize());
            this.tablePanel.setSize(this.tablePanel.getPreferredSize());
        } else {
            this.tablePanel.setPreferredSize(new Dimension(this.tablePanel.getWidth(), this.tablePanel.getInitialHeight()));
            this.tablePanel.setMinimumSize(this.tablePanel.getPreferredSize());
            this.tablePanel.setSize(this.tablePanel.getPreferredSize());
        }
    }

    public void generateThumbs() {
        this.thumbGenerator = new ThumbGeneratorThread(this.itemPanel);
        this.thumbGenerator.start();
    }

    public void setSelectedFile(File f) {
        this.filechooserUI.setCurrentDirectoryOfFileChooser(f);
    }

    public void updatePath(File file) {
        this.fc.setCursor(this.waitCursor);
        this.clearEveryThing();
        this.exploreFolder(file);
        this.fc.setCursor(this.normalCursor);
    }

    protected void updateThumbnail() {
        if (this.itemPanel.getCurrentView().equals("Thumbnails")) {
            this.thumbGenerator.stop();
            this.thumbGenerator = new ThumbGeneratorThread(this.itemPanel);
            this.thumbGenerator.start();
        }
    }

    public void rescanDirectory() {
        this.tempFile = this.fc.getCurrentDirectory();
        try {
            this.tempFile = this.tempFile.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File[] files = this.tempFile.listFiles();
        TreeMap<File, File> filesMap = new TreeMap<File, File>();
        Enumeration<Object> en = this.completeItemsList.elements();
        while (en.hasMoreElements()) {
            Item item = (Item)en.nextElement();
            filesMap.put(item.getFile(), item.getFile());
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File element;
            this.tempFile = element = fileArray[n2];
            try {
                this.tempFile = this.tempFile.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!filesMap.containsKey(this.tempFile)) {
                Item item = new Item(this.itemPanel, this.tempFile);
                this.completeItemsList.add(item);
                this.visibleItemsList.add(item);
                item.addKeyListener(this.keyListener);
                this.itemPanel.add(item);
                this.itemPanel.findBestConfig(item);
                this.itemPanel.repaint();
                this.scrollRectToVisible(item.getBounds());
            }
            ++n2;
        }
        Vector<Item> removingItems = new Vector<Item>();
        filesMap.clear();
        File[] fileArray2 = files;
        int n3 = files.length;
        n = 0;
        while (n < n3) {
            File element;
            this.tempFile = element = fileArray2[n];
            try {
                this.tempFile = this.tempFile.getCanonicalFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
            filesMap.put(this.tempFile, this.tempFile);
            ++n;
        }
        int j = 0;
        while (j < this.completeItemsList.size()) {
            Item item = (Item)this.completeItemsList.elementAt(j);
            if (!filesMap.containsKey(item.getFile())) {
                removingItems.add(item);
            }
            ++j;
        }
        Enumeration n4 = removingItems.elements();
        while (n4.hasMoreElements()) {
            Item item = (Item)n4.nextElement();
            this.completeItemsList.remove(item);
            this.visibleItemsList.remove(item);
            this.itemPanel.remove(item);
            if (!this.selectedFilesVector.contains(item)) continue;
            this.selectedFilesVector.remove(item);
        }
        files = null;
        if (this.filechooserUI.getView().equals("Details")) {
            this.updateTableData();
        } else if (this.filechooserUI.getView().equals("Thumbnails")) {
            this.stopTumbnailGeneration();
            this.generateThumbs();
        }
        this.orderBy(this.ORDER_BY, true);
        this.arrangeTheFiles();
        this.repaint();
    }

    private void exploreFolder(File file) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.currentFile != null) {
            this.filechooserUI.backPathVector.add(this.currentFile.getPath());
            this.filechooserUI.getGoBackAction().setEnabled(true);
        } else {
            this.filechooserUI.getGoBackAction().setEnabled(false);
        }
        this.currentFile = file;
        File[] files = file.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File element;
                this.tempFile = element = fileArray[n2];
                try {
                    this.tempFile = element.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!this.currentFile.toString().equals("My Computer") && this.tempFile.exists() && this.tempFile.canRead() || this.currentFile.toString().equals("My Computer")) {
                    Item item = new Item(this.itemPanel, this.tempFile);
                    item.addKeyListener(this.keyListener);
                    this.completeItemsList.add(item);
                }
                ++n2;
            }
        }
        files = null;
        this.doDefaults();
        this.requestFocus();
        this.repaint();
    }

    public FileSystemView getFSV() {
        return this.fsv;
    }

    public void stopTumbnailGeneration() {
        this.thumbGenerator.stop();
        this.thumbGenerator = new ThumbGeneratorThread(this.itemPanel);
    }

    public void clearEveryThing() {
        this.itemPanel.removeAll();
        this.lastSelected = null;
        this.completeItemsList.removeAllElements();
        this.visibleItemsList.removeAllElements();
        this.selectedFilesVector.removeAllElements();
        this.completeItemsList.removeAllElements();
        Enumeration<Object> en = this.completeItemsList.elements();
        while (en.hasMoreElements()) {
            Item t = (Item)en.nextElement();
            t.finalizeAll();
            Object var2_2 = null;
        }
    }

    public void clearSelectedItemsList() {
        Enumeration<Object> en = this.selectedFilesVector.elements();
        while (en.hasMoreElements()) {
            Item item = (Item)en.nextElement();
            item.updateSelectionMode(false);
            item.repaint();
        }
        this.selectedFilesVector.clear();
        this.fc.setSelectedFiles(null);
        this.repaint();
    }

    public boolean isItemSelected(Item item) {
        return this.selectedFilesVector.contains(item);
    }

    protected void updateFilechooserSelectedItems(Item t, boolean ctrl) {
        if (!ctrl || !this.fc.isMultiSelectionEnabled()) {
            Enumeration<Object> en = this.completeItemsList.elements();
            while (en.hasMoreElements()) {
                ((Item)en.nextElement()).updateSelectionMode(false);
            }
            this.selectedFilesVector.removeAllElements();
        }
        t.updateSelectionMode(!t.getSelectionMode());
        if (t.getSelectionMode()) {
            this.itemPanel.scrollRectToVisible(t.getBounds());
            if (!this.selectedFilesVector.contains(t)) {
                this.selectedFilesVector.add(t);
            }
        } else if (this.selectedFilesVector.contains(t)) {
            this.selectedFilesVector.remove(t);
        }
        this.lastSelected = t;
        this.synchFilechoserSelection();
    }

    public void requestFocus() {
        if (this.filechooserUI.viewType.equals("Details")) {
            this.tablePanel.requestFocus();
        } else {
            this.itemPanel.requestFocus();
        }
    }

    protected void synchFilechoserSelection() {
        int counter = 0;
        this.selectedFilesArray = new File[this.selectedFilesVector.size()];
        Vector<Item> tempVector = new Vector<Item>();
        Enumeration<Object> en = this.selectedFilesVector.elements();
        while (en.hasMoreElements()) {
            Item item = (Item)en.nextElement();
            if ((!this.fc.isDirectorySelectionEnabled() || !item.isDirectory()) && (!this.fc.isFileSelectionEnabled() || item.isDirectory())) continue;
            tempVector.add(item);
        }
        this.selectedFilesArray = new File[tempVector.size()];
        en = tempVector.elements();
        counter = 0;
        while (en.hasMoreElements()) {
            this.selectedFilesArray[counter] = ((Item)en.nextElement()).getFile();
            ++counter;
        }
        this.fc.setSelectedFiles(this.selectedFilesArray);
    }

    protected JPopupMenu getPanePopup() {
        if (this.panePopup != null) {
            return this.panePopup;
        }
        this.mal = new MenuListener(this);
        this.panePopup = new JPopupMenu();
        this.menuItem = new JMenuItem("New Folder");
        this.menuItem.addActionListener(this.mal);
        this.panePopup.add(this.menuItem);
        this.addToBookmarksMenuItem = new JMenuItem("Add to Bookmarks");
        this.addToBookmarksMenuItem.addActionListener(this.mal);
        this.panePopup.add(this.addToBookmarksMenuItem);
        this.panePopup.addSeparator();
        this.menuItem = new JMenuItem("Refresh");
        this.menuItem.addActionListener(this.mal);
        this.panePopup.add(this.menuItem);
        this.menuItem = new JMenuItem("Select All");
        this.menuItem.addActionListener(this.mal);
        this.panePopup.add(this.menuItem);
        JMenu orderMenuItem = new JMenu("Order By");
        this.panePopup.add(orderMenuItem);
        this.orderButtonGroup = new ButtonGroup();
        this.menuItem = new JRadioButtonMenuItem(ORDER_BY_FILE_NAME);
        this.menuItem.setSelected(true);
        this.menuItem.addActionListener(this.mal);
        this.menuItem.setActionCommand("ORDER:" + ORDER_BY_FILE_NAME);
        orderMenuItem.add(this.menuItem);
        this.orderButtonGroup.add(this.menuItem);
        this.menuItem = new JRadioButtonMenuItem(ORDER_BY_FILE_TYPE);
        this.menuItem.addActionListener(this.mal);
        this.menuItem.setActionCommand("ORDER:" + ORDER_BY_FILE_TYPE);
        orderMenuItem.add(this.menuItem);
        this.orderButtonGroup.add(this.menuItem);
        this.menuItem = new JRadioButtonMenuItem(ORDER_BY_FILE_SIZE);
        this.menuItem.addActionListener(this.mal);
        this.menuItem.setActionCommand("ORDER:" + ORDER_BY_FILE_SIZE);
        orderMenuItem.add(this.menuItem);
        this.orderButtonGroup.add(this.menuItem);
        this.menuItem = new JRadioButtonMenuItem(ORDER_BY_FILE_MODIFIED);
        this.menuItem.addActionListener(this.mal);
        this.menuItem.setActionCommand("ORDER:" + ORDER_BY_FILE_MODIFIED);
        orderMenuItem.add(this.menuItem);
        this.orderButtonGroup.add(this.menuItem);
        this.panePopup.addSeparator();
        JMenu viewMenuItem = new JMenu("View Type");
        this.panePopup.add(viewMenuItem);
        this.viewButtonGroup = new ButtonGroup();
        this.menuItem = new JRadioButtonMenuItem("Thumbnails");
        this.menuItem.addActionListener(this.mal);
        this.menuItem.setActionCommand("viewType:Thumbnails");
        viewMenuItem.add(this.menuItem);
        this.viewButtonGroup.add(this.menuItem);
        this.menuItem = new JRadioButtonMenuItem("Icons");
        this.menuItem.addActionListener(this.mal);
        this.menuItem.setActionCommand("viewType:Icons");
        viewMenuItem.add(this.menuItem);
        this.viewButtonGroup.add(this.menuItem);
        this.menuItem = new JRadioButtonMenuItem("List");
        this.menuItem.addActionListener(this.mal);
        this.menuItem.setSelected(true);
        this.menuItem.setActionCommand("viewType:List");
        viewMenuItem.add(this.menuItem);
        this.viewButtonGroup.add(this.menuItem);
        this.menuItem = new JRadioButtonMenuItem("Details");
        this.menuItem.addActionListener(this.mal);
        this.menuItem.setActionCommand("viewType:Details");
        viewMenuItem.add(this.menuItem);
        this.viewButtonGroup.add(this.menuItem);
        viewMenuItem.addSeparator();
        this.autoArrangeCheckBox = new JCheckBoxMenuItem("Auto arrange");
        this.autoArrangeCheckBox.setSelected(true);
        viewMenuItem.add(this.autoArrangeCheckBox);
        return this.panePopup;
    }

    public boolean isAutoArrange() {
        return this.autoArrangeCheckBox.isSelected();
    }

    public void orderBy(String str, boolean newPath) {
        if (!newPath && this.ORDER_BY.equals(str)) {
            this.tempList.clear();
            int i = this.completeItemsList.size() - 1;
            while (i >= 0) {
                this.tempList.add(this.completeItemsList.elementAt(i));
                --i;
            }
            this.completeItemsList.clear();
            this.completeItemsList = (Vector)this.tempList.clone();
        } else {
            this.tempCompareTree.clear();
            Enumeration<Object> en = this.completeItemsList.elements();
            while (en.hasMoreElements()) {
                Item item = (Item)en.nextElement();
                item.setCompare_type(str);
                this.tempCompareTree.put(item, item);
            }
            this.completeItemsList.clear();
            this.completeItemsList = new Vector<Item>(this.tempCompareTree.values());
        }
        this.ORDER_BY = str;
        Enumeration<AbstractButton> en = this.orderButtonGroup.getElements();
        while (en.hasMoreElements()) {
            JRadioButtonMenuItem rbm = (JRadioButtonMenuItem)en.nextElement();
            if (!rbm.getActionCommand().equals("ORDER:" + this.getOrder())) continue;
            this.orderButtonGroup.setSelected(rbm.getModel(), true);
        }
        this.findVisibleItems();
    }

    private void arrangeTheFiles() {
        if (this.filechooserUI.viewType.equals("Details")) {
            this.changeCardForView();
        } else {
            this.itemPanel.arrangeTheFiles();
        }
    }

    public void doFilterChanged() {
        this.findVisibleItems();
        this.changeCardForView();
        if (this.visibleItemsList.size() > 0) {
            this.lastSelected = this.visibleItemsList.get(0);
        }
    }

    public void selectAll() {
        if (this.fc.isMultiSelectionEnabled()) {
            if (this.filechooserUI.getView().equals("Details")) {
                this.tablePanel.selectAll();
            } else {
                this.clearSelectedItemsList();
                Enumeration<Item> tempEn = this.visibleItemsList.elements();
                while (tempEn.hasMoreElements()) {
                    Item item = tempEn.nextElement();
                    item.updateSelectionMode(true);
                    this.selectedFilesVector.add(item);
                    item.repaint();
                }
                this.synchFilechoserSelection();
            }
        }
    }

    public void doDefaults() {
        this.orderBy(this.ORDER_BY, true);
        this.changeCardForView();
        if (this.visibleItemsList.size() > 0) {
            this.lastSelected = this.visibleItemsList.get(0);
        }
    }

    protected void findVisibleItems() {
        this.visibleItemsList.clear();
        this.itemPanel.removeAll();
        Enumeration<Object> en = this.completeItemsList.elements();
        while (en.hasMoreElements()) {
            this.tempFlag = true;
            Item item = (Item)en.nextElement();
            if (item.getFile().isHidden() && this.fc.isFileHidingEnabled()) {
                this.tempFlag = false;
            }
            if (this.tempFlag && this.fc.getFileFilter() != null && !this.fc.getFileFilter().accept(item.getFile())) {
                this.tempFlag = false;
            }
            if (this.tempFlag && !this.fc.isFileSelectionEnabled() && item.getFile().isFile()) {
                this.tempFlag = false;
            }
            if (this.tempFlag) {
                item.setVisible(true);
            } else {
                item.setVisible(false);
            }
            if (!this.tempFlag) continue;
            this.visibleItemsList.add(item);
            this.itemPanel.add(item);
        }
    }

    protected void updateTableData() {
        Enumeration<Item> els = this.visibleItemsList.elements();
        Vector<Object> vec2 = new Vector<Object>();
        int ni = 0;
        int si = 1;
        int ti = 2;
        int li = 3;
        try {
            ni = this.tablePanel.getColumnModel().getColumnIndex("File Name");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            si = this.tablePanel.getColumnModel().getColumnIndex("Size");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ti = this.tablePanel.getColumnModel().getColumnIndex("Type");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            li = this.tablePanel.getColumnModel().getColumnIndex("Last modified");
        }
        catch (Exception exception) {}
        while (els.hasMoreElements()) {
            Item tc = els.nextElement();
            Object[] arr = new Object[4];
            arr[ni] = new FileTableLabel(tc.getFileName(), tc.getSmallSystemIcon(), 2);
            arr[si] = tc.convertToCorrectFormat(tc.getFileSize());
            arr[ti] = tc.getFileType();
            arr[li] = DateFormat.getDateInstance().format(new Date(tc.getLastModificationTime()));
            vec2.add(arr.clone());
        }
        Object[][] res = new Object[vec2.size()][];
        Enumeration<Object> en = vec2.elements();
        int c = 0;
        while (en.hasMoreElements()) {
            res[c] = (Object[])en.nextElement();
            ++c;
        }
        this.updateTablePanelSize();
        this.tablePanel.updateData(res);
        this.updateTablePanelSize();
        en = this.selectedFilesVector.elements();
        int i = 0;
        while (en.hasMoreElements()) {
            Item item = (Item)en.nextElement();
            this.tablePanel.updateSelectionInterval(this.visibleItemsList.indexOf(item), true);
            ++i;
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("FILECHOOSER_VIEW_TYPE")) {
            this.filechooserUI.updateView(evt.getNewValue().toString());
        }
    }

    public String getOrder() {
        return this.ORDER_BY;
    }

    private static class MenuListener
    implements ActionListener {
        private FileList fileList;

        public MenuListener(FileList fileList) {
            this.fileList = fileList;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (e.getActionCommand().equals("New Folder")) {
                    this.fileList.filechooserUI.getNewFolderAction().actionPerformed(null);
                } else if (e.getActionCommand().equals("Refresh")) {
                    this.fileList.rescanDirectory();
                } else if (e.getActionCommand().startsWith("ORDER")) {
                    this.fileList.orderBy(e.getActionCommand().substring(e.getActionCommand().lastIndexOf(58) + 1), false);
                    this.fileList.arrangeTheFiles();
                } else if (e.getActionCommand().startsWith("viewType")) {
                    this.fileList.filechooserUI.updateView(e.getActionCommand().substring(e.getActionCommand().lastIndexOf(58) + 1));
                } else if (e.getActionCommand().equals("Select All")) {
                    this.fileList.selectAll();
                } else if (e.getActionCommand().equals("Add to Bookmarks")) {
                    this.fileList.addToBookmarks();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

