/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.gui.plotter.PlotterAdapter;
import com.rapidminer.gui.plotter.ScatterPlotter;
import com.rapidminer.gui.plotter.conditions.ColumnsPlotterCondition;
import com.rapidminer.gui.plotter.conditions.PlotterCondition;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.LogService;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JProgressBar;
import javax.swing.filechooser.FileFilter;

public class ScatterMatrixPlotter
extends PlotterAdapter {
    private static final long serialVersionUID = 9049081889010883621L;
    static final int MAX_NUMBER_OF_COLUMNS = 50;
    private ScatterPlotter plotter = new ScatterPlotter();
    private BufferedImage[][] images = new BufferedImage[0][0];
    private int plotDimension = -1;
    private transient DataTable dataTable;
    private int plotterSize;
    private JProgressBar progressBar = new JProgressBar();
    private Thread calculationThread = null;
    private boolean stopUpdates = false;

    public ScatterMatrixPlotter() {
        this.setBackground(Color.white);
        String sizeProperty = System.getProperty("rapidminer.gui.plotter.matrixplot.size");
        this.plotterSize = 200;
        try {
            if (sizeProperty != null) {
                this.plotterSize = Integer.parseInt(sizeProperty);
            }
        }
        catch (NumberFormatException e) {
            LogService.getGlobal().log("Scatter matrix: cannot parse plotter size (was '" + sizeProperty + "'), using default size (200).", 5);
        }
        this.plotter.setDrawLegend(false);
        this.plotter.setDrawAxes(false);
        this.plotter.getPlotter().setSize(new Dimension(this.plotterSize, this.plotterSize));
        this.progressBar.setToolTipText("Shows the progress of the Scatter Matrix calculation.");
    }

    public ScatterMatrixPlotter(DataTable dataTable) {
        this();
        this.setDataTable(dataTable);
    }

    public void forcePlotGeneration() {
        this.updatePlotters();
    }

    public void stopUpdates(boolean value) {
        this.stopUpdates = value;
    }

    public void setDataTable(DataTable dataTable) {
        super.setDataTable(dataTable);
        this.dataTable = dataTable;
        if (!this.stopUpdates) {
            this.updatePlottersInThread();
        }
    }

    public PlotterCondition getPlotterCondition() {
        return new ColumnsPlotterCondition(50);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.calculationThread == null) {
            int x = 0;
            while (x < this.images.length) {
                int y = 0;
                while (y < this.images[x].length) {
                    Graphics2D newSpace = (Graphics2D)graphics.create();
                    newSpace.translate(x * this.plotterSize, y * this.plotterSize + 20);
                    newSpace.drawImage(this.images[x][y], null, 0, 0);
                    ++y;
                }
                ++x;
            }
        }
        if (this.plotDimension != -1) {
            this.drawLegend(graphics, this.dataTable, this.plotDimension);
        }
    }

    private synchronized void updatePlotters() {
        if (this.plotDimension >= 0) {
            this.images = new BufferedImage[this.dataTable.getNumberOfColumns()][this.dataTable.getNumberOfColumns()];
            int counter = 0;
            int firstIndex = 0;
            int x = 0;
            while (x < this.dataTable.getNumberOfColumns()) {
                if (x != this.plotDimension) {
                    int secondIndex = 0;
                    int y = 0;
                    while (y < this.dataTable.getNumberOfColumns()) {
                        if (y != this.plotDimension) {
                            Graphics2D graphics;
                            if (firstIndex == secondIndex) {
                                this.images[firstIndex][secondIndex] = new BufferedImage(this.plotterSize, this.plotterSize, 2);
                                graphics = this.images[firstIndex][secondIndex].createGraphics();
                                graphics.setColor(Color.WHITE);
                                graphics.fillRect(0, 0, this.plotterSize, this.plotterSize);
                            } else {
                                this.plotter.setDataTable(this.dataTable);
                                this.plotter.setAxis(0, x);
                                this.plotter.setAxis(1, y);
                                this.plotter.setPlotColumn(this.plotDimension, true);
                                this.images[firstIndex][secondIndex] = new BufferedImage(this.plotterSize, this.plotterSize, 2);
                                graphics = this.images[firstIndex][secondIndex].createGraphics();
                                this.plotter.paint2DPlots(graphics);
                            }
                            ++secondIndex;
                        }
                        this.progressBar.setValue(++counter);
                        ++y;
                    }
                    ++firstIndex;
                }
                ++x;
            }
            this.progressBar.setValue(0);
            this.revalidate();
            this.repaint();
        } else {
            this.images = new BufferedImage[0][0];
            this.revalidate();
            this.repaint();
        }
    }

    private void updatePlottersInThread() {
        if (this.plotDimension >= 0) {
            if (this.calculationThread == null) {
                this.progressBar.setMinimum(0);
                this.progressBar.setMaximum(this.images.length * this.images.length);
                this.progressBar.setValue(0);
                this.calculationThread = new Thread(){

                    public void run() {
                        ScatterMatrixPlotter.this.updatePlotters();
                        ScatterMatrixPlotter.this.calculationFinished();
                    }
                };
                this.calculationThread.start();
            }
        } else {
            this.images = new BufferedImage[0][0];
            this.revalidate();
            this.repaint();
        }
    }

    private void calculationFinished() {
        this.calculationThread = null;
    }

    public Dimension getPreferredSize() {
        if (this.images.length > 0) {
            return new Dimension((this.images.length - 1) * this.plotterSize + 40, (this.images.length - 1) * this.plotterSize + 40);
        }
        return new Dimension(40, 40);
    }

    public String getAxisName(int index) {
        return "none";
    }

    public Icon getIcon(int index) {
        return null;
    }

    public boolean isSaveable() {
        return true;
    }

    public void save() {
        JFileChooser chooser = SwingTools.createFileChooser(null, false, new FileFilter[0]);
        if (chooser.showSaveDialog(this) == 0) {
            File file = chooser.getSelectedFile();
            PrintWriter out = null;
            try {
                try {
                    out = new PrintWriter(new FileWriter(file));
                    this.dataTable.write(out);
                    out.close();
                }
                catch (Exception ex) {
                    SwingTools.showSimpleErrorMessage("Cannot write to file '" + file + "'", ex);
                    if (out != null) {
                        out.close();
                    }
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    public boolean canHandleJitter() {
        return true;
    }

    public boolean canHandleContinousJittering() {
        return false;
    }

    public void setJitter(int jitter) {
        this.plotter.setJitter(jitter);
        if (!this.stopUpdates) {
            this.updatePlottersInThread();
        }
    }

    public void setPlotColumn(int index, boolean plot) {
        this.plotDimension = plot ? index : -1;
        if (!this.stopUpdates) {
            this.updatePlottersInThread();
        }
    }

    public boolean getPlotColumn(int index) {
        return this.plotDimension == index;
    }

    public JComponent getOptionsComponent(int index) {
        switch (index) {
            case 0: {
                return this.progressBar;
            }
        }
        return null;
    }
}

