/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer.similarity;

import com.rapidminer.datatable.SimpleDataTable;
import com.rapidminer.datatable.SimpleDataTableRow;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.plotter.Plotter;
import com.rapidminer.gui.plotter.charts.HistogramChart;
import com.rapidminer.gui.renderer.AbstractRenderer;
import com.rapidminer.gui.renderer.DefaultReadable;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.similarity.SimilarityMeasure;
import com.rapidminer.report.Reportable;
import com.rapidminer.tools.math.similarity.DistanceMeasure;
import java.awt.Component;
import java.util.Random;
import javax.swing.JLabel;

public class SimilarityHistogramRenderer
extends AbstractRenderer {
    public String getName() {
        return "Histogram";
    }

    private Plotter createHistogramPlotter(Object renderable, ExampleSet exampleSet) {
        SimilarityMeasure sim = (SimilarityMeasure)renderable;
        DistanceMeasure measure = sim.getDistanceMeasure();
        SimpleDataTable dataTable = new SimpleDataTable("Histogram", new String[]{"Histogram"});
        double sampleRatio = Math.min(1.0, 500.0 / (double)exampleSet.size());
        Random random = new Random();
        int i = 0;
        for (Example example : exampleSet) {
            int j = 0;
            for (Example comExample : exampleSet) {
                if (j != i && random.nextDouble() < sampleRatio) {
                    double simValue = measure.isDistance() ? measure.calculateDistance(example, comExample) : measure.calculateSimilarity(example, comExample);
                    dataTable.add(new SimpleDataTableRow(new double[]{simValue}));
                }
                ++j;
            }
            ++i;
        }
        HistogramChart histogramView = new HistogramChart();
        histogramView.setDataTable(dataTable);
        histogramView.setPlotColumn(0, true);
        histogramView.setBinNumber(100);
        return histogramView;
    }

    public Reportable createReportable(Object renderable, IOContainer ioContainer, int width, int height) {
        try {
            ExampleSet exampleSet = ioContainer.get(ExampleSet.class);
            Plotter plotter = this.createHistogramPlotter(renderable, exampleSet);
            plotter.getPlotter().setSize(width, height);
            return plotter;
        }
        catch (MissingIOObjectException e) {
            return new DefaultReadable("No exampleset provided for similarity calculation");
        }
    }

    public Component getVisualizationComponent(Object renderable, IOContainer ioContainer) {
        try {
            ExampleSet exampleSet = ioContainer.get(ExampleSet.class);
            Plotter plotter = this.createHistogramPlotter(renderable, exampleSet);
            return plotter.getPlotter();
        }
        catch (MissingIOObjectException e) {
            return new JLabel("No exampleset provided for similarity calculation");
        }
    }
}

