/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering.clusterer;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.InputDescription;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.clustering.DendogramHierarchicalClusterModel;
import com.rapidminer.operator.clustering.HierarchicalClusterLeafNode;
import com.rapidminer.operator.clustering.HierarchicalClusterModel;
import com.rapidminer.operator.clustering.HierarchicalClusterNode;
import com.rapidminer.operator.clustering.clusterer.AbstractLinkageMethod;
import com.rapidminer.operator.clustering.clusterer.Agglomeration;
import com.rapidminer.operator.clustering.clusterer.AverageLinkageMethod;
import com.rapidminer.operator.clustering.clusterer.CompleteLinkageMethod;
import com.rapidminer.operator.clustering.clusterer.DistanceMatrix;
import com.rapidminer.operator.clustering.clusterer.SingleLinkageMethod;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.tools.math.similarity.DistanceMeasure;
import com.rapidminer.tools.math.similarity.DistanceMeasures;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgglomerativeClustering
extends Operator {
    public static final String PARAMETER_MODE = "mode";
    public static final String[] modes = new String[]{"SingleLink", "CompleteLink", "AverageLink"};

    public AgglomerativeClustering(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        DistanceMeasure measure = DistanceMeasures.createMeasure(this, exampleSet, this.getInput());
        measure.init(exampleSet);
        Tools.onlyNonMissingValues(exampleSet, "AgglomerativeClustering");
        Attribute idAttribute = exampleSet.getAttributes().getId();
        boolean idAttributeIsNominal = idAttribute.isNominal();
        DistanceMatrix matrix = new DistanceMatrix(exampleSet.size());
        HashMap<Integer, HierarchicalClusterNode> clusterMap = new HashMap<Integer, HierarchicalClusterNode>(exampleSet.size());
        int[] clusterIds = new int[exampleSet.size()];
        int nextClusterId = 0;
        for (Example example1 : exampleSet) {
            clusterIds[nextClusterId] = nextClusterId;
            int y = 0;
            for (Example example2 : exampleSet) {
                if (y > nextClusterId) {
                    matrix.set(nextClusterId, y, measure.calculateDistance(example1, example2));
                }
                ++y;
            }
            if (idAttributeIsNominal) {
                clusterMap.put(nextClusterId, new HierarchicalClusterLeafNode(nextClusterId, example1.getValueAsString(idAttribute)));
            } else {
                clusterMap.put(nextClusterId, new HierarchicalClusterLeafNode(nextClusterId, (Object)example1.getValue(idAttribute)));
            }
            ++nextClusterId;
        }
        AbstractLinkageMethod linkage = new SingleLinkageMethod(matrix, clusterIds);
        if (this.getParameterAsString(PARAMETER_MODE).equals(modes[1])) {
            linkage = new CompleteLinkageMethod(matrix, clusterIds);
        } else if (this.getParameterAsString(PARAMETER_MODE).equals(modes[2])) {
            linkage = new AverageLinkageMethod(matrix, clusterIds);
        }
        while (clusterMap.size() > 1) {
            Agglomeration agglomeration = linkage.getNextAgglomeration(nextClusterId, clusterMap);
            HierarchicalClusterNode newNode = new HierarchicalClusterNode(nextClusterId, agglomeration.getDistance());
            newNode.addSubNode((HierarchicalClusterNode)clusterMap.get(agglomeration.getClusterId1()));
            newNode.addSubNode((HierarchicalClusterNode)clusterMap.get(agglomeration.getClusterId2()));
            clusterMap.remove(agglomeration.getClusterId1());
            clusterMap.remove(agglomeration.getClusterId2());
            clusterMap.put(nextClusterId, newNode);
            ++nextClusterId;
        }
        DendogramHierarchicalClusterModel model = new DendogramHierarchicalClusterModel((HierarchicalClusterNode)clusterMap.entrySet().iterator().next().getValue());
        return new IOObject[]{model};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{HierarchicalClusterModel.class};
    }

    public InputDescription getInputDescription(Class cls) {
        if (ExampleSet.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, true, true);
        }
        return super.getInputDescription(cls);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeStringCategory(PARAMETER_MODE, "Specifies the cluster mode.", modes, modes[0]));
        types.addAll(DistanceMeasures.getParameterTypes(this));
        return types;
    }
}

