/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.weighting;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.features.Individual;
import com.rapidminer.operator.features.Population;
import com.rapidminer.operator.features.PopulationOperator;
import com.rapidminer.operator.features.weighting.FeatureWeighting;
import com.rapidminer.operator.features.weighting.SimpleWeighting;

public class BackwardWeighting
extends FeatureWeighting {
    public BackwardWeighting(OperatorDescription description) {
        super(description);
    }

    public PopulationOperator getWeightingOperator(String parameter) {
        double[] weights = new double[]{1.0, 0.75, 0.5, 0.25};
        if (parameter != null && parameter.length() != 0) {
            try {
                String[] weightStrings = parameter.split(" ");
                weights = new double[weightStrings.length];
                int i = 0;
                while (i < weights.length) {
                    weights[i] = Double.parseDouble(weightStrings[i]);
                    ++i;
                }
            }
            catch (Exception e) {
                this.logError("Could not create weights: " + e.getMessage() + "! Use standard weights.");
                weights = new double[]{1.0, 0.75, 0.5, 0.25};
            }
        }
        return new SimpleWeighting(1.0, weights);
    }

    public Population createInitialPopulation(ExampleSet es) {
        Population initPop = new Population();
        double[] weights = new double[es.getAttributes().size()];
        int i = 0;
        while (i < weights.length) {
            weights[i] = 1.0;
            ++i;
        }
        initPop.add(new Individual(weights));
        return initPop;
    }
}

