/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.example.table.ResultSetDataRowReader;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractExampleSource;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.jdbc.DatabaseHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResultSetExampleSource
extends AbstractExampleSource {
    public static final String PARAMETER_LABEL_ATTRIBUTE = "label_attribute";
    public static final String PARAMETER_ID_ATTRIBUTE = "id_attribute";
    public static final String PARAMETER_WEIGHT_ATTRIBUTE = "weight_attribute";
    public static final String PARAMETER_DATAMANAGEMENT = "datamanagement";

    public ResultSetExampleSource(OperatorDescription description) {
        super(description);
    }

    public abstract ResultSet getResultSet() throws OperatorException;

    public abstract void tearDown();

    public abstract void setNominalValues(List<Attribute> var1, ResultSet var2, Attribute var3) throws OperatorException;

    @Override
    public ExampleSet createExampleSet() throws OperatorException {
        int dataRowType = this.getParameterAsInt(PARAMETER_DATAMANAGEMENT);
        ResultSet resultSet = this.getResultSet();
        List<Attribute> attributeList = null;
        try {
            attributeList = DatabaseHandler.createAttributes(resultSet);
        }
        catch (SQLException e) {
            throw new UserError((Operator)this, (Throwable)e, 304, e.getMessage());
        }
        this.setNominalValues(attributeList, resultSet, ResultSetExampleSource.find(attributeList, this.getParameterAsString(PARAMETER_LABEL_ATTRIBUTE)));
        ResultSetDataRowReader reader = new ResultSetDataRowReader(new DataRowFactory(dataRowType, '.'), attributeList, resultSet);
        MemoryExampleTable table = new MemoryExampleTable(attributeList, reader);
        this.tearDown();
        return ResultSetExampleSource.createExampleSet(table, this);
    }

    private static Attribute find(List attributeList, String name) throws OperatorException {
        if (name == null) {
            return null;
        }
        for (Attribute attribute : attributeList) {
            if (!attribute.getName().equals(name)) continue;
            return attribute;
        }
        throw new UserError(null, 111, name);
    }

    public static ExampleSet createExampleSet(ExampleTable table, Operator operator) throws OperatorException {
        String labelName = operator.getParameterAsString(PARAMETER_LABEL_ATTRIBUTE);
        String weightName = operator.getParameterAsString(PARAMETER_WEIGHT_ATTRIBUTE);
        String idName = operator.getParameterAsString(PARAMETER_ID_ATTRIBUTE);
        Attribute label = table.findAttribute(labelName);
        Attribute weight = table.findAttribute(weightName);
        Attribute id = table.findAttribute(idName);
        HashMap<Attribute, String> specialMap = new HashMap<Attribute, String>();
        specialMap.put(label, "label");
        specialMap.put(weight, "weight");
        specialMap.put(id, "id");
        return table.createExampleSet(specialMap);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeString type = new ParameterTypeString(PARAMETER_LABEL_ATTRIBUTE, "The (case sensitive) name of the label attribute");
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeString(PARAMETER_ID_ATTRIBUTE, "The (case sensitive) name of the id attribute"));
        types.add(new ParameterTypeString(PARAMETER_WEIGHT_ATTRIBUTE, "The (case sensitive) name of the weight attribute"));
        types.add(new ParameterTypeCategory(PARAMETER_DATAMANAGEMENT, "Determines, how the data is represented internally.", DataRowFactory.TYPE_NAMES, 0));
        return types;
    }
}

