/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.associations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PowerSet<ItemT>
implements Iterable<Collection<ItemT>>,
Iterator<Collection<ItemT>> {
    private ArrayList<ItemT> set;
    private boolean[] subSetIndicator;

    public PowerSet(Collection<ItemT> collection) {
        this.set = new ArrayList<ItemT>(collection);
    }

    @Override
    public Iterator<Collection<ItemT>> iterator() {
        return new PowerSet<ItemT>(this.set);
    }

    public Collection<ItemT> getComplement(Collection<ItemT> collection) {
        ArrayList<ItemT> complement = new ArrayList<ItemT>(this.set.size() - collection.size());
        Iterator<ItemT> iterator = this.set.iterator();
        block0: for (ItemT item : collection) {
            while (iterator.hasNext()) {
                ItemT currentSetItem = iterator.next();
                if (currentSetItem == item) continue block0;
                complement.add(currentSetItem);
            }
        }
        while (iterator.hasNext()) {
            complement.add(iterator.next());
        }
        return complement;
    }

    @Override
    public boolean hasNext() {
        if (this.subSetIndicator == null) {
            return true;
        }
        int i = 0;
        while (i < this.subSetIndicator.length) {
            if (!this.subSetIndicator[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public Collection<ItemT> next() {
        if (this.subSetIndicator == null) {
            this.subSetIndicator = new boolean[this.set.size()];
        } else {
            int i = 0;
            while (i < this.subSetIndicator.length) {
                if (!this.subSetIndicator[i]) {
                    this.subSetIndicator[i] = true;
                    break;
                }
                this.subSetIndicator[i] = false;
                ++i;
            }
        }
        ArrayList<ItemT> subset = new ArrayList<ItemT>();
        int i = 0;
        while (i < this.subSetIndicator.length) {
            if (this.subSetIndicator[i]) {
                subset.add(this.set.get(i));
            }
            ++i;
        }
        return subset;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("The 'remove' operation is not supported by power sets!");
    }
}

