/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.subgroups.utility;

import com.rapidminer.operator.learner.subgroups.hypothesis.Hypothesis;
import com.rapidminer.operator.learner.subgroups.hypothesis.Rule;
import com.rapidminer.operator.learner.subgroups.utility.UtilityFunction;

public class WRAcc
extends UtilityFunction {
    public WRAcc(double totalWeight, double totalPredictionWeight) {
        super(totalWeight, totalPredictionWeight);
    }

    public double utility(Rule rule) {
        double g = rule.getCoveredWeight() / this.totalWeight;
        double p = rule.getPredictionWeight() / rule.getCoveredWeight();
        double p0 = this.priors[rule.predictsPositive() ? 1 : 0];
        return g * (p - p0);
    }

    public double optimisticEstimate(Hypothesis hypothesis) {
        double g = hypothesis.getCoveredWeight() / this.totalWeight;
        return g * Math.max(this.priors[1], this.priors[0]);
    }

    public String getName() {
        return "WRAcc";
    }

    public String getAbbreviation() {
        return "WRAcc";
    }
}

