/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.meta.ParameterOptimizationOperator;
import com.rapidminer.operator.meta.ParameterSet;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.parameter.value.ParameterValueRange;
import com.rapidminer.parameter.value.ParameterValues;
import java.util.Iterator;
import java.util.List;

public class GridSearchParameterOptimizationOperator
extends ParameterOptimizationOperator {
    protected Operator[] operators;
    protected String[] parameters;
    protected String[][] values;
    protected int[] currentIndex;
    protected int numberOfCombinations;
    protected int numberOfParameters;
    private ParameterSet best;

    public GridSearchParameterOptimizationOperator(OperatorDescription description) {
        super(description);
    }

    public int getParameterValueMode() {
        return 0;
    }

    protected void getParametersToOptimize() throws OperatorException {
        List<ParameterValues> parameterValuesList = this.parseParameterValues(this.getParameterList("parameters"));
        this.numberOfCombinations = 1;
        this.numberOfParameters = parameterValuesList.size();
        Iterator<ParameterValues> iterator = parameterValuesList.iterator();
        while (iterator.hasNext()) {
            ParameterValues parameterValues = iterator.next();
            if (parameterValues instanceof ParameterValueRange) {
                this.logWarning("found (and deleted) parameter values range (" + parameterValues.getKey() + ") which makes no sense in grid parameter optimization");
                iterator.remove();
            }
            this.numberOfCombinations *= parameterValues.getNumberOfValues();
        }
        this.operators = new Operator[parameterValuesList.size()];
        this.parameters = new String[parameterValuesList.size()];
        this.values = new String[parameterValuesList.size()][];
        this.currentIndex = new int[parameterValuesList.size()];
        int i = 0;
        for (ParameterValues parameterValues : parameterValuesList) {
            this.operators[i] = parameterValues.getOperator();
            this.parameters[i] = parameterValues.getParameterType().getKey();
            this.values[i] = parameterValues.getValuesArray();
            ++i;
        }
    }

    public double getCurrentBestPerformance() {
        if (this.best != null) {
            return this.best.getPerformance().getMainCriterion().getAverage();
        }
        return Double.NaN;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public IOObject[] apply() throws OperatorException {
        IOContainer input = this.getInput();
        this.getParametersToOptimize();
        this.log("Total number of combinations is " + this.numberOfCombinations);
        if (this.numberOfCombinations <= 1) {
            throw new UserError(this, 922);
        }
        int counter = 1;
        this.best = null;
        while (true) {
            boolean ok;
            block10: {
                int n;
                int k;
                block9: {
                    this.log("Using parameter set " + counter + " / " + this.numberOfCombinations + ":");
                    int j = 0;
                    while (j < this.operators.length) {
                        this.operators[j].getParameters().setParameter(this.parameters[j], this.values[j][this.currentIndex[j]]);
                        this.log(this.operators[j] + "." + this.parameters[j] + " = " + this.values[j][this.currentIndex[j]]);
                        ++j;
                    }
                    this.setInput(input.copy());
                    PerformanceVector performance = this.getPerformance();
                    if (this.best == null || performance != null && performance.compareTo(this.best.getPerformance()) > 0) {
                        String[] bestValues = new String[this.parameters.length];
                        int j2 = 0;
                        while (j2 < this.parameters.length) {
                            bestValues[j2] = this.values[j2][this.currentIndex[j2]];
                            ++j2;
                        }
                        this.best = new ParameterSet(this.operators, this.parameters, bestValues, performance);
                    }
                    k = 0;
                    ok = true;
                    if (!true) break block9;
                    n = k;
                    if ((this.currentIndex[n] = this.currentIndex[n] + 1) < this.values[k].length) break block10;
                }
                do {
                    this.currentIndex[k] = 0;
                    if (++k >= this.currentIndex.length) {
                        ok = false;
                        break;
                    }
                    n = k;
                } while ((this.currentIndex[n] = this.currentIndex[n] + 1) >= this.values[k].length);
            }
            if (!ok) {
                return new IOObject[]{this.best, this.best.getPerformance()};
            }
            this.inApplyLoop();
            ++counter;
        }
    }
}

