/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.Process;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.tools.XMLException;
import java.io.File;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessEmbeddingOperator
extends Operator {
    public static final String PARAMETER_PROCESS_FILE = "process_file";
    public static final String PARAMETER_USE_INPUT = "use_input";

    public ProcessEmbeddingOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        File processFile = this.getParameterAsFile(PARAMETER_PROCESS_FILE);
        Process process = null;
        try {
            process = new Process(processFile);
        }
        catch (IOException e) {
            throw new UserError((Operator)this, 302, processFile, e.getMessage());
        }
        catch (XMLException e) {
            throw new UserError((Operator)this, 401, e.getMessage());
        }
        IOContainer result = null;
        result = this.getParameterAsBoolean(PARAMETER_USE_INPUT) ? process.run(this.getInput()) : process.run();
        return result.getIOObjects();
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[0];
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile(PARAMETER_PROCESS_FILE, "The process file which should be encapsulated by this operator", "xml", false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_INPUT, "Indicates if the operator input should be used as input of the process", false));
        return types;
    }
}

