/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.InputDescription;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.performance.AbstractExampleSetEvaluator;
import com.rapidminer.operator.performance.EstimatedPerformance;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Data2Performance
extends AbstractExampleSetEvaluator {
    public static final String PARAMETER_PERFORMANCE_TYPE = "performance_type";
    public static final String PARAMETER_ATTRIBUTE_VALUE = "attribute_value";
    public static final String PARAMETER_STATISTICS = "statistics";
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    public static final String PARAMETER_EXAMPLE_INDEX = "example_index";
    public static final String PARAMETER_OPTIMIZATION_DIRECTION = "optimization_direction";
    public static final String[] OPTIMIZATION_DIRECTIONS = new String[]{"minimize", "maximize"};
    public static final int OPTIMIZATION_DIRECTION_MINIMIZE = 0;
    public static final int OPTIMIZATION_DIRECTION_MAXIMIZE = 1;
    public static final String[] MACRO_TYPES = new String[]{"number_of_examples", "number_of_attributes", "data_value", "statistics"};
    public static final int MACRO_TYPE_EXAMPLES = 0;
    public static final int MACRO_TYPE_ATTRIBUTES = 1;
    public static final int MACRO_TYPE_DATA = 2;
    public static final int MACRO_TYPE_STATISTICS = 3;
    public static final String[] STATISTICS_TYPES = new String[]{"average", "min", "max", "count"};
    public static final int STATISTICS_TYPE_AVERAGE = 0;
    public static final int STATISTICS_TYPE_MIN = 1;
    public static final int STATISTICS_TYPE_MAX = 2;
    public static final int STATISTICS_TYPE_COUNT = 3;
    private double performanceValue = Double.NaN;

    public Data2Performance(OperatorDescription description) {
        super(description);
        this.addValue(new ValueDouble("performance", "The last calculated performance."){

            public double getDoubleValue() {
                return Data2Performance.this.performanceValue;
            }
        });
    }

    @Override
    public PerformanceVector evaluate(ExampleSet exampleSet) throws OperatorException {
        this.performanceValue = Double.NaN;
        block0 : switch (this.getParameterAsInt(PARAMETER_PERFORMANCE_TYPE)) {
            case 1: {
                this.performanceValue = exampleSet.getAttributes().size();
                break;
            }
            case 0: {
                this.performanceValue = exampleSet.size();
                break;
            }
            case 2: {
                int exampleIndex = this.getParameterAsInt(PARAMETER_EXAMPLE_INDEX);
                if (exampleIndex == 0) {
                    throw new UserError((Operator)this, 207, "0", PARAMETER_EXAMPLE_INDEX, "only positive or negative indices are allowed");
                }
                exampleIndex = exampleIndex < 0 ? exampleSet.size() + exampleIndex : --exampleIndex;
                if (exampleIndex >= exampleSet.size()) {
                    throw new UserError((Operator)this, 110, exampleIndex);
                }
                Attribute attribute = exampleSet.getAttributes().get(this.getParameter(PARAMETER_ATTRIBUTE_NAME));
                if (attribute == null) {
                    throw new UserError((Operator)this, 111, this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME));
                }
                Example example = exampleSet.getExample(exampleIndex);
                this.performanceValue = example.getValue(attribute);
                break;
            }
            case 3: {
                Attribute attribute = exampleSet.getAttributes().get(this.getParameter(PARAMETER_ATTRIBUTE_NAME));
                if (attribute == null) {
                    throw new UserError((Operator)this, 111, this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME));
                }
                exampleSet.recalculateAttributeStatistics(attribute);
                int statisticsType = this.getParameterAsInt(PARAMETER_STATISTICS);
                switch (statisticsType) {
                    case 0: {
                        if (attribute.isNominal()) {
                            this.performanceValue = exampleSet.getStatistics(attribute, "mode");
                            break block0;
                        }
                        this.performanceValue = exampleSet.getStatistics(attribute, "average");
                        break block0;
                    }
                    case 2: {
                        this.performanceValue = exampleSet.getStatistics(attribute, "maximum");
                        break block0;
                    }
                    case 1: {
                        this.performanceValue = exampleSet.getStatistics(attribute, "minimum");
                        break block0;
                    }
                    case 3: {
                        if (attribute.isNominal()) {
                            String attributeValue = this.getParameterAsString(PARAMETER_ATTRIBUTE_VALUE);
                            int index = attribute.getMapping().getIndex(attributeValue);
                            if (index < 0) {
                                throw new UserError((Operator)this, 143, attributeValue, attribute.getName());
                            }
                            this.performanceValue = exampleSet.getStatistics(attribute, "count", attributeValue);
                            break block0;
                        }
                        throw new UserError((Operator)this, 119, attribute.getName(), this.getName());
                    }
                }
            }
        }
        PerformanceVector result = new PerformanceVector();
        EstimatedPerformance performance = new EstimatedPerformance("Data Based Performance", this.performanceValue, 1, this.getParameterAsInt(PARAMETER_OPTIMIZATION_DIRECTION) == 0);
        result.addCriterion(performance);
        return result;
    }

    public InputDescription getInputDescription(Class cls) {
        if (ExampleSet.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, false, true);
        }
        return super.getInputDescription(cls);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_PERFORMANCE_TYPE, "Indicates the way how the macro should be defined.", MACRO_TYPES, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_STATISTICS, "The statistics of the specified attribute which should be used as macro value.", STATISTICS_TYPES, 0);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_PERFORMANCE_TYPE, true, 3));
        types.add(type);
        type = new ParameterTypeString(PARAMETER_ATTRIBUTE_NAME, "The name of the attribute from which the data should be derived.", true);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_PERFORMANCE_TYPE, true, 2, 3));
        types.add(type);
        type = new ParameterTypeString(PARAMETER_ATTRIBUTE_VALUE, "The value of the attribute which should be counted.", true);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_PERFORMANCE_TYPE, true, 3));
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_STATISTICS, true, 3));
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_EXAMPLE_INDEX, "The index of the example from which the data should be derived. Negative indices are counted from the end of the data set. Positive counting starts with 1, negative counting with -1.", -2147483647, Integer.MAX_VALUE, true);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_PERFORMANCE_TYPE, true, 2));
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_OPTIMIZATION_DIRECTION, "Indicates if the performance value should be minimized or maximized.", OPTIMIZATION_DIRECTIONS, 1);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

