/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.filter.FeatureFilter;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.tools.Ontology;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureBlockTypeFilter
extends FeatureFilter {
    public static final String PARAMETER_SKIP_FEATURES_OF_TYPE = "skip_features_of_type";
    public static final String PARAMETER_EXCEPT_FEATURES_OF_TYPE = "except_features_of_type";

    public FeatureBlockTypeFilter(OperatorDescription description) {
        super(description);
    }

    @Override
    public boolean switchOffFeature(AttributeRole role) throws OperatorException {
        Attribute feature = role.getAttribute();
        int type = this.getParameterAsInt(PARAMETER_SKIP_FEATURES_OF_TYPE) + 1;
        int exceptionType = this.getParameterAsInt(PARAMETER_EXCEPT_FEATURES_OF_TYPE);
        if (exceptionType == 0) {
            return Ontology.ATTRIBUTE_BLOCK_TYPE.isA(feature.getBlockType(), type);
        }
        return Ontology.ATTRIBUTE_BLOCK_TYPE.isA(feature.getBlockType(), type) && !Ontology.ATTRIBUTE_BLOCK_TYPE.isA(feature.getBlockType(), exceptionType);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        String[] blockTypes = new String[Ontology.BLOCK_TYPE_NAMES.length - 1];
        int i = 0;
        while (i < blockTypes.length) {
            blockTypes[i] = Ontology.BLOCK_TYPE_NAMES[i + 1];
            ++i;
        }
        ParameterTypeCategory type = new ParameterTypeCategory(PARAMETER_SKIP_FEATURES_OF_TYPE, "All features of this type will be deselected off.", blockTypes, 0);
        type.setExpert(false);
        types.add(type);
        String[] exceptionBlockTypes = new String[blockTypes.length + 1];
        exceptionBlockTypes[0] = "none";
        System.arraycopy(blockTypes, 0, exceptionBlockTypes, 1, blockTypes.length);
        types.add(new ParameterTypeCategory(PARAMETER_EXCEPT_FEATURES_OF_TYPE, "All features of this type will not be deselected.", exceptionBlockTypes, 0));
        return types;
    }
}

