/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.text;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.text.TextObject;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextObjectLoader
extends Operator {
    private static final String PARAMETER_FILE = "file";

    public TextObjectLoader(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        File file = this.getParameterAsFile(PARAMETER_FILE);
        if (file.exists()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(file));
                StringBuffer result = new StringBuffer();
                String inputLine = reader.readLine();
                while (inputLine != null) {
                    result.append(inputLine);
                    inputLine = reader.readLine();
                }
                reader.close();
                return new IOObject[]{new TextObject(result.toString())};
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new IOObject[0];
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> parameters = super.getParameterTypes();
        parameters.add(new ParameterTypeFile(PARAMETER_FILE, "Specifies the file, the text will be written into.", "*", false));
        return parameters;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{TextObject.class};
    }
}

