/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.validation;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.validation.Tools;
import com.rapidminer.operator.validation.ValidationChain;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.tools.math.AverageVector;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XValidation
extends ValidationChain {
    public static final String PARAMETER_NUMBER_OF_VALIDATIONS = "number_of_validations";
    public static final String PARAMETER_LEAVE_ONE_OUT = "leave_one_out";
    public static final String PARAMETER_SAMPLING_TYPE = "sampling_type";
    public static final String PARAMETER_AVERAGE_PERFORMANCES_ONLY = "average_performances_only";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";
    private int iteration;

    public XValidation(OperatorDescription description) {
        super(description);
        this.addValue(new ValueDouble("iteration", "The number of the current iteration."){

            public double getDoubleValue() {
                return XValidation.this.iteration;
            }
        });
    }

    @Override
    public IOObject[] estimatePerformance(ExampleSet inputSet) throws OperatorException {
        int number = this.getParameterAsBoolean(PARAMETER_LEAVE_ONE_OUT) ? inputSet.size() : this.getParameterAsInt(PARAMETER_NUMBER_OF_VALIDATIONS);
        this.log("Starting " + number + "-fold cross validation");
        int samplingType = this.getParameterAsInt(PARAMETER_SAMPLING_TYPE);
        int randomSeed = this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED);
        SplittedExampleSet splittedES = new SplittedExampleSet(inputSet, number, samplingType, randomSeed);
        ArrayList<AverageVector> averageVectors = new ArrayList<AverageVector>();
        this.iteration = 0;
        while (this.iteration < number) {
            splittedES.selectAllSubsetsBut(this.iteration);
            this.learn(splittedES);
            splittedES.selectSingleSubset(this.iteration);
            IOContainer evalOutput = this.evaluate(splittedES);
            Tools.handleAverages(evalOutput, averageVectors, this.getParameterAsBoolean(PARAMETER_AVERAGE_PERFORMANCES_ONLY));
            this.inApplyLoop();
            ++this.iteration;
        }
        PerformanceVector averagePerformance = Tools.getPerformanceVector(averageVectors);
        if (averagePerformance != null) {
            this.setResult(averagePerformance);
        }
        IOObject[] result = new AverageVector[averageVectors.size()];
        averageVectors.toArray(result);
        return result;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_AVERAGE_PERFORMANCES_ONLY, "Indicates if only performance vectors should be averaged or all types of averagable result vectors", true));
        types.add(new ParameterTypeBoolean(PARAMETER_LEAVE_ONE_OUT, "Set the number of validations to the number of examples. If set to true, number_of_validations is ignored", false));
        ParameterTypeSingle type = new ParameterTypeInt(PARAMETER_NUMBER_OF_VALIDATIONS, "Number of subsets for the crossvalidation.", 2, Integer.MAX_VALUE, 10);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_LEAVE_ONE_OUT, false, false));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_SAMPLING_TYPE, "Defines the sampling type of the cross validation (linear = consecutive subsets, shuffled = random subsets, stratified = random subsets with class distribution kept constant)", SplittedExampleSet.SAMPLING_NAMES, 2);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_LEAVE_ONE_OUT, false, false));
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Use the given random seed instead of global random numbers (-1: use global)", -1, Integer.MAX_VALUE, -1);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_LEAVE_ONE_OUT, false, false));
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_SAMPLING_TYPE, false, 1, 2));
        types.add(type);
        return types;
    }
}

