/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.validation.significance;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.validation.significance.SignificanceTestOperator;
import com.rapidminer.tools.math.AnovaCalculator;
import com.rapidminer.tools.math.SignificanceCalculationException;
import com.rapidminer.tools.math.SignificanceTestResult;

public class AnovaSignificanceTestOperator
extends SignificanceTestOperator {
    public AnovaSignificanceTestOperator(OperatorDescription description) {
        super(description);
    }

    public SignificanceTestResult performSignificanceTest(PerformanceVector[] allVectors, double alpha) throws OperatorException {
        AnovaCalculator calculator = new AnovaCalculator();
        calculator.setAlpha(alpha);
        int i = 0;
        while (i < allVectors.length) {
            PerformanceCriterion pc = allVectors[i].getMainCriterion();
            calculator.addGroup(pc.getAverageCount(), pc.getAverage(), pc.getVariance());
            ++i;
        }
        try {
            return calculator.performSignificanceTest();
        }
        catch (SignificanceCalculationException e) {
            throw new UserError((Operator)this, 920, e.getMessage());
        }
    }

    public int getMinSize() {
        return 2;
    }

    public int getMaxSize() {
        return Integer.MAX_VALUE;
    }
}

