/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.tools.math.ROCData;
import com.rapidminer.tools.math.ROCDataGenerator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ROCChartGenerator
extends Operator {
    public static final String PARAMETER_USE_EXAMPLE_WEIGHTS = "use_example_weights";
    public static final String PARAMETER_USE_MODEL = "use_model";

    public ROCChartGenerator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        if (exampleSet.getAttributes().getLabel() == null) {
            throw new UserError(this, 105);
        }
        if (!exampleSet.getAttributes().getLabel().isNominal()) {
            throw new UserError((Operator)this, 101, "ROC Charts", exampleSet.getAttributes().getLabel());
        }
        if (exampleSet.getAttributes().getLabel().getMapping().getValues().size() != 2) {
            throw new UserError((Operator)this, 114, "ROC Charts", exampleSet.getAttributes().getLabel());
        }
        if (exampleSet.getAttributes().getPredictedLabel() != null && this.getParameterAsBoolean(PARAMETER_USE_MODEL)) {
            this.logWarning("Input example already has a predicted label which will be removed.");
            PredictionModel.removePredictedLabel(exampleSet);
        }
        if (exampleSet.getAttributes().getPredictedLabel() == null && !this.getParameterAsBoolean(PARAMETER_USE_MODEL)) {
            throw new UserError(this, 107);
        }
        Model model = null;
        if (this.getParameterAsBoolean(PARAMETER_USE_MODEL)) {
            model = this.getInput(Model.class);
            exampleSet = model.apply(exampleSet);
        }
        if (exampleSet.getAttributes().getPredictedLabel() == null) {
            throw new UserError(this, 107);
        }
        ROCDataGenerator rocDataGenerator = new ROCDataGenerator(1.0, 1.0);
        ROCData rocPoints = rocDataGenerator.createROCData(exampleSet, this.getParameterAsBoolean(PARAMETER_USE_EXAMPLE_WEIGHTS));
        rocDataGenerator.createROCPlotDialog(rocPoints);
        PredictionModel.removePredictedLabel(exampleSet);
        if (this.getParameterAsBoolean(PARAMETER_USE_MODEL)) {
            return new IOObject[]{exampleSet, model};
        }
        return new IOObject[]{exampleSet};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class, Model.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class, Model.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_USE_EXAMPLE_WEIGHTS, "Indicates if example weights should be used for calculations (use 1 as weights for each example otherwise).", true));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_MODEL, "If checked a given model will be applied for generating ROCChart. If not the examples set must have a predicted label.", true));
        return types;
    }
}

