/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Vector;

public class BasenameList {
    private Vector bList = null;
    private String fromDir = null;
    private String fromExt = null;
    private boolean hasChanged;
    private static final int DEFAULT_INCREMENT = 128;

    public BasenameList() {
        this.fromDir = null;
        this.fromExt = null;
        this.bList = new Vector(128, 128);
        this.hasChanged = false;
    }

    public BasenameList(String setFromDir, String setFromExt, Vector setVec) {
        this.fromDir = setFromDir;
        this.fromExt = setFromExt;
        this.bList = setVec;
        this.hasChanged = false;
    }

    public BasenameList(String[] str) {
        this.fromDir = null;
        this.fromExt = null;
        this.bList = new Vector(128, 128);
        this.add(str);
        this.hasChanged = false;
    }

    public BasenameList(String dirName, final String extension) {
        this.fromDir = dirName;
        this.fromExt = extension.indexOf(".") != 0 ? "." + extension : extension;
        File dir = new File(dirName);
        if (!dir.exists()) {
            throw new RuntimeException("Directory [" + dirName + "] does not exist. Can't find the [" + extension + "] files.");
        }
        Object[] selectedFiles = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(extension);
            }
        });
        Arrays.sort(selectedFiles);
        this.bList = new Vector(selectedFiles.length, 128);
        String str = null;
        int subtractFromFilename = extension.length();
        for (int i = 0; i < selectedFiles.length; ++i) {
            str = ((File)selectedFiles[i]).getName().substring(0, ((File)selectedFiles[i]).getName().length() - subtractFromFilename);
            this.add(str);
        }
        this.hasChanged = false;
    }

    public BasenameList(String fileName) throws IOException {
        this.load(fileName);
        this.hasChanged = false;
    }

    public void write(String fileName) throws IOException {
        this.write(new File(fileName));
    }

    public void write(File file) throws IOException {
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"), true);
        if (this.fromDir != null) {
            pw.println("FROM: " + this.fromDir + "*" + this.fromExt);
        }
        String str = null;
        for (int i = 0; i < this.bList.size(); ++i) {
            str = (String)this.bList.elementAt(i);
            pw.println(str);
        }
    }

    public void load(String fileName) throws IOException {
        String line;
        BufferedReader bfr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8"));
        if (this.bList == null) {
            this.bList = new Vector(128, 128);
        }
        if ((line = bfr.readLine()).indexOf("FROM: ") != -1) {
            line = line.substring(6);
            String[] parts = new String[2];
            parts = line.split("\\*", 2);
            this.fromDir = parts[0];
            this.fromExt = parts[1];
        } else if (!line.matches("^\\s*$")) {
            this.add(line);
        }
        while ((line = bfr.readLine()) != null) {
            if (line.matches("^\\s*$")) continue;
            this.add(line);
        }
    }

    public void add(String str) {
        if (!this.bList.contains(str)) {
            this.bList.add(str);
        }
        this.hasChanged = true;
    }

    public void add(String[] str) {
        for (int i = 0; i < str.length; ++i) {
            this.add(str[i]);
        }
        this.hasChanged = true;
    }

    public boolean remove(String str) {
        this.hasChanged = true;
        return this.bList.remove(str);
    }

    public boolean remove(BasenameList bnl) {
        boolean ret = true;
        for (int i = 0; i < bnl.getLength(); ++i) {
            this.bList.remove(bnl.getName(i));
        }
        this.hasChanged = true;
        return ret;
    }

    public BasenameList duplicate() {
        return new BasenameList(this.fromDir, this.fromExt, (Vector)this.bList.clone());
    }

    public BasenameList subList(int fromIndex, int toIndex) {
        Vector<String> subVec = new Vector<String>(toIndex - fromIndex, 128);
        for (int i = fromIndex; i < toIndex; ++i) {
            subVec.add(this.getName(i));
        }
        return new BasenameList(this.fromDir, this.fromExt, subVec);
    }

    public String[] getListAsArray() {
        String[] ret = new String[this.getLength()];
        ret = this.bList.toArray(ret);
        return ret;
    }

    public Vector getListAsVector() {
        return this.bList;
    }

    public int getLength() {
        return this.bList.size();
    }

    public String getDir() {
        return this.fromDir;
    }

    public String getExt() {
        return this.fromExt;
    }

    public String getName(int i) {
        return (String)this.bList.elementAt(i);
    }

    public boolean contains(String str) {
        return this.bList.contains(str);
    }

    public boolean contains(BasenameList bnl) {
        if (bnl.getLength() > this.getLength()) {
            return false;
        }
        for (int i = 0; i < bnl.getLength(); ++i) {
            if (this.contains(bnl.getName(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(BasenameList bnl) {
        if (bnl.getLength() != this.getLength()) {
            return false;
        }
        for (int i = 0; i < bnl.getLength(); ++i) {
            if (this.contains(bnl.getName(i))) continue;
            return false;
        }
        return true;
    }

    public void sort() {
        Object[] str = this.getListAsArray();
        Arrays.sort(str);
        this.bList.removeAllElements();
        this.add((String[])str);
        this.hasChanged = true;
    }

    public void clear() {
        this.fromDir = null;
        this.fromExt = null;
        this.bList.removeAllElements();
        this.hasChanged = true;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }
}

