/*
 * Decompiled with CFR 0.152.
 */
package marytts.vocalizations;

import java.io.FileInputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import marytts.exceptions.MaryConfigurationException;
import marytts.exceptions.SynthesisException;
import marytts.htsengine.HMMData;
import marytts.htsengine.HTSPStream;
import marytts.htsengine.HTSVocoder;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.math.MathUtils;
import marytts.util.math.Polynomial;
import marytts.vocalizations.MLSAFeatureFileReader;
import marytts.vocalizations.VocalizationIntonationReader;
import marytts.vocalizations.VocalizationSynthesisTechnology;

public class MLSASynthesisTechnology
extends VocalizationSynthesisTechnology {
    protected MLSAFeatureFileReader vMLSAFeaturesReader;
    protected VocalizationIntonationReader vIntonationReader;
    protected HMMData htsData;
    protected HTSVocoder par2speech;
    protected boolean imposePolynomialContour = true;

    public MLSASynthesisTechnology(String mlsaFeatureFile, String intonationFeatureFile, String mixedExcitationFile, boolean imposePolynomialContour) throws MaryConfigurationException {
        try {
            this.vMLSAFeaturesReader = new MLSAFeatureFileReader(mlsaFeatureFile);
            this.vIntonationReader = intonationFeatureFile != null ? new VocalizationIntonationReader(intonationFeatureFile) : null;
        }
        catch (IOException ioe) {
            throw new MaryConfigurationException("Problem with loading mlsa feature file", ioe);
        }
        if (this.vMLSAFeaturesReader.getNumberOfUnits() <= 0) {
            throw new MaryConfigurationException("mlsa feature file doesn't contain any data");
        }
        this.imposePolynomialContour = imposePolynomialContour;
        try {
            this.htsData = new HMMData();
            this.htsData.setUseMixExc(true);
            this.htsData.setUseFourierMag(false);
            FileInputStream mixedFiltersStream = new FileInputStream(mixedExcitationFile);
            this.htsData.setNumFilters(5);
            this.htsData.setOrderFilters(48);
            this.htsData.readMixedExcitationFilters(mixedFiltersStream);
            this.htsData.setPdfStrStream(null);
            this.htsData.setF0Std(1.0);
            this.htsData.setF0Mean(0.0);
        }
        catch (Exception e) {
            throw new MaryConfigurationException("htsData initialization failed.. ", e);
        }
        this.par2speech = new HTSVocoder();
    }

    @Override
    public AudioInputStream synthesize(int backchannelNumber, AudioFileFormat aft) throws SynthesisException {
        if (backchannelNumber > this.vMLSAFeaturesReader.getNumberOfUnits()) {
            throw new IllegalArgumentException("requesting unit should not be more than number of units");
        }
        if (backchannelNumber < 0) {
            throw new IllegalArgumentException("requesting unit index should not be less than zero");
        }
        double[] lf0 = this.vMLSAFeaturesReader.getUnitLF0(backchannelNumber);
        boolean[] voiced = this.vMLSAFeaturesReader.getVoicedFrames(backchannelNumber);
        double[][] mgc = this.vMLSAFeaturesReader.getUnitMGCs(backchannelNumber);
        double[][] strengths = this.vMLSAFeaturesReader.getUnitStrengths(backchannelNumber);
        return this.synthesizeUsingMLSAVocoder(mgc, strengths, lf0, voiced, aft);
    }

    @Override
    public AudioInputStream reSynthesize(int backchannelNumber, AudioFileFormat aft) throws SynthesisException {
        return this.synthesize(backchannelNumber, aft);
    }

    @Override
    public AudioInputStream synthesizeUsingImposedF0(int sourceIndex, int targetIndex, AudioFileFormat aft) throws SynthesisException {
        if (sourceIndex > this.vMLSAFeaturesReader.getNumberOfUnits() || targetIndex > this.vMLSAFeaturesReader.getNumberOfUnits()) {
            throw new IllegalArgumentException("requesting unit should not be more than number of units");
        }
        if (sourceIndex < 0 || targetIndex < 0) {
            throw new IllegalArgumentException("requesting unit index should not be less than zero");
        }
        boolean[] voiced = this.vMLSAFeaturesReader.getVoicedFrames(sourceIndex);
        double[][] mgc = this.vMLSAFeaturesReader.getUnitMGCs(sourceIndex);
        double[][] strengths = this.vMLSAFeaturesReader.getUnitStrengths(sourceIndex);
        double[] lf0 = null;
        if (!this.imposePolynomialContour) {
            lf0 = MathUtils.arrayResize(this.vMLSAFeaturesReader.getUnitLF0(targetIndex), voiced.length);
        } else {
            double[] targetF0coeffs = this.vIntonationReader.getIntonationCoeffs(targetIndex);
            double[] sourceF0coeffs = this.vIntonationReader.getIntonationCoeffs(sourceIndex);
            if (targetF0coeffs == null || sourceF0coeffs == null) {
                return this.reSynthesize(sourceIndex, aft);
            }
            if (targetF0coeffs.length == 0 || sourceF0coeffs.length == 0) {
                return this.reSynthesize(sourceIndex, aft);
            }
            double[] f0Contour = Polynomial.generatePolynomialValues(targetF0coeffs, voiced.length, 0.0, 1.0);
            lf0 = new double[f0Contour.length];
            for (int i = 0; i < f0Contour.length; ++i) {
                lf0[i] = Math.log(f0Contour[i]);
            }
        }
        return this.synthesizeUsingMLSAVocoder(mgc, strengths, lf0, voiced, aft);
    }

    private AudioInputStream synthesizeUsingMLSAVocoder(double[][] mgc, double[][] strengths, double[] lf0, boolean[] voiced, AudioFileFormat aft) throws SynthesisException {
        AudioFormat af;
        assert (lf0.length == mgc.length);
        assert (mgc.length == strengths.length);
        for (int i = 0; i < lf0.length; ++i) {
            if (!(lf0[i] > 0.0) || !(Math.log(30.0) > lf0[i]) && !(Math.log(1000.0) < lf0[i])) continue;
            throw new SynthesisException("given log f0 values should be in the natural pitch range ");
        }
        int mcepVsize = this.vMLSAFeaturesReader.getMGCVectorSize();
        int lf0Vsize = this.vMLSAFeaturesReader.getLF0VectorSize();
        int strVsize = this.vMLSAFeaturesReader.getSTRVectorSize();
        HTSPStream lf0Pst = null;
        HTSPStream mcepPst = null;
        HTSPStream strPst = null;
        try {
            lf0Pst = new HTSPStream(lf0Vsize * 3, lf0.length, 1, 0);
            mcepPst = new HTSPStream(mcepVsize * 3, mgc.length, 2, 0);
            strPst = new HTSPStream(strVsize * 3, strengths.length, 3, 0);
        }
        catch (Exception e) {
            throw new SynthesisException("HTSPStream initialiaztion failed.. " + e);
        }
        int lf0VoicedFrame = 0;
        for (int i = 0; i < lf0.length; ++i) {
            int j;
            if (voiced[i]) {
                lf0Pst.setPar(lf0VoicedFrame, 0, lf0[i]);
                ++lf0VoicedFrame;
            }
            for (j = 0; j < mcepPst.getOrder(); ++j) {
                mcepPst.setPar(i, j, mgc[i][j]);
            }
            for (j = 0; j < strPst.getOrder(); ++j) {
                strPst.setPar(i, j, strengths[i][j]);
            }
        }
        if (aft == null) {
            float sampleRate = 16000.0f;
            int sampleSizeInBits = 16;
            int channels = 1;
            boolean signed = true;
            boolean bigEndian = false;
            af = new AudioFormat(sampleRate, sampleSizeInBits, channels, signed, bigEndian);
        } else {
            af = aft.getFormat();
        }
        double[] audio_double = null;
        try {
            audio_double = this.par2speech.htsMLSAVocoder(lf0Pst, mcepPst, strPst, null, voiced, this.htsData, null);
        }
        catch (Exception e) {
            throw new SynthesisException("MLSA vocoding failed .. " + e);
        }
        double MaxSample = MathUtils.getAbsMax(audio_double);
        for (int i = 0; i < audio_double.length; ++i) {
            audio_double[i] = 0.3 * (audio_double[i] / MaxSample);
        }
        return new DDSAudioInputStream(new BufferedDoubleDataSource(audio_double), af);
    }
}

