/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import opennlp.tools.postag.POSSample;
import opennlp.tools.postag.POSTagger;
import opennlp.tools.util.eval.Evaluator;
import opennlp.tools.util.eval.Mean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POSEvaluator
extends Evaluator<POSSample> {
    private POSTagger tagger;
    private Mean wordAccuracy = new Mean();

    public POSEvaluator(POSTagger tagger) {
        this.tagger = tagger;
    }

    @Override
    public void evaluateSample(POSSample reference) {
        String[] predictedTags = this.tagger.tag(reference.getSentence());
        for (int i = 0; i < reference.getTags().length; ++i) {
            if (reference.getTags()[i].equals(predictedTags[i])) {
                this.wordAccuracy.add(1.0);
                continue;
            }
            this.wordAccuracy.add(0.0);
        }
    }

    public double getWordAccuracy() {
        return this.wordAccuracy.mean();
    }

    public long getWordCount() {
        return this.wordAccuracy.count();
    }

    public String toString() {
        return "Accuracy:" + this.wordAccuracy.mean() + " Number of Samples: " + this.wordAccuracy.count();
    }
}

