/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data;

import java.util.Arrays;
import marytts.util.data.BaseDoubleDataSource;

public class SilenceDoubleDataSource
extends BaseDoubleDataSource {
    protected long n;

    public SilenceDoubleDataSource(long n) {
        this.n = n;
        this.dataLength = n;
    }

    @Override
    public boolean hasMoreData() {
        return this.n > 0L;
    }

    @Override
    public int available() {
        return (int)this.n;
    }

    @Override
    public int getData(double[] target, int targetPos, int length) {
        if (target.length - targetPos < length) {
            throw new IllegalArgumentException("Target array cannot hold enough data (" + (target.length - targetPos) + " left, but " + length + " requested)");
        }
        int toCopy = (int)Math.min((long)length, this.n);
        Arrays.fill(target, targetPos, targetPos + toCopy, 0.0);
        this.n -= (long)toCopy;
        return toCopy;
    }
}

