/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import org.hsqldb.RowAVL;
import org.hsqldb.TableBase;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class RowAVLDiskData
extends RowAVL {
    PersistentStore store;
    int accessCount;
    boolean hasDataChanged;
    int storageSize;

    public RowAVLDiskData(PersistentStore persistentStore, TableBase tableBase, Object[] objectArray) {
        super(tableBase, objectArray);
        this.setNewNodes();
        this.hasDataChanged = true;
        this.store = persistentStore;
    }

    public RowAVLDiskData(PersistentStore persistentStore, TableBase tableBase, RowInputInterface rowInputInterface) throws IOException {
        super(tableBase, null);
        this.setNewNodes();
        this.position = rowInputInterface.getPos();
        this.storageSize = rowInputInterface.getSize();
        this.rowData = rowInputInterface.readData(this.table.getColumnTypes());
        this.hasDataChanged = false;
        this.store = persistentStore;
    }

    public void setData(Object[] objectArray) {
        this.rowData = objectArray;
    }

    @Override
    public Object[] getData() {
        if (this.rowData == null) {
            this.store.get(this, false);
        } else {
            ++this.accessCount;
        }
        return this.rowData;
    }

    @Override
    public void setNewNodes() {
        int n = this.table.getIndexCount();
        NodeAVL nodeAVL = this.nPrimaryNode = new NodeAVL(this);
        for (int i = 1; i < n; ++i) {
            nodeAVL = nodeAVL.nNext = new NodeAVL(this);
        }
    }

    @Override
    public NodeAVL insertNode(int n) {
        NodeAVL nodeAVL = this.getNode(n - 1);
        NodeAVL nodeAVL2 = new NodeAVL(this);
        nodeAVL2.nNext = nodeAVL.nNext;
        nodeAVL.nNext = nodeAVL2;
        return nodeAVL2;
    }

    void setPrimaryNode(NodeAVL nodeAVL) {
        this.nPrimaryNode = nodeAVL;
    }

    @Override
    public int getRealSize(RowOutputInterface rowOutputInterface) {
        return rowOutputInterface.getSize(this);
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface) {
        rowOutputInterface.writeSize(this.storageSize);
        rowOutputInterface.writeData(this.getData(), this.table.colTypes);
        rowOutputInterface.writeEnd();
        this.hasDataChanged = false;
    }

    @Override
    public boolean hasChanged() {
        return this.hasDataChanged;
    }

    @Override
    public void updateAccessCount(int n) {
        this.accessCount = n;
    }

    @Override
    public int getAccessCount() {
        return this.accessCount;
    }

    @Override
    public int getStorageSize() {
        return this.storageSize;
    }

    @Override
    public void setStorageSize(int n) {
        this.storageSize = n;
    }

    @Override
    public void setPos(int n) {
        this.position = n;
    }

    @Override
    public boolean isMemory() {
        return true;
    }

    @Override
    public boolean equals(Object object) {
        return object == this;
    }

    @Override
    public boolean isInMemory() {
        return this.rowData != null;
    }

    @Override
    public boolean isKeepInMemory() {
        return false;
    }

    @Override
    public boolean keepInMemory(boolean bl) {
        return true;
    }

    @Override
    public void setInMemory(boolean bl) {
        if (!bl) {
            this.rowData = null;
        }
    }
}

