/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib.tar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Properties;
import org.hsqldb.lib.tar.RB;
import org.hsqldb.lib.tar.TarGenerator;
import org.hsqldb.lib.tar.TarMalformatException;
import org.hsqldb.lib.tar.TarReader;

public class DbBackup {
    protected File dbDir;
    protected File archiveFile;
    protected String instanceName;
    protected boolean overWrite = false;
    protected boolean abortUponModify = true;

    public static void main(String[] stringArray) throws IOException, TarMalformatException {
        block13: {
            try {
                if (stringArray.length < 1) {
                    System.out.println(RB.DbBackup_syntax.getString(DbBackup.class.getName()));
                    System.out.println();
                    System.out.println(RB.listing_format.getString());
                    System.exit(0);
                }
                if (stringArray[0].equals("--save")) {
                    boolean bl = stringArray.length > 1 && stringArray[1].equals("--overwrite");
                    if (stringArray.length != (bl ? 4 : 3)) {
                        throw new IllegalArgumentException();
                    }
                    DbBackup dbBackup = new DbBackup(new File(stringArray[stringArray.length - 2]), stringArray[stringArray.length - 1]);
                    dbBackup.setOverWrite(bl);
                    dbBackup.write();
                    break block13;
                }
                if (stringArray[0].equals("--list")) {
                    if (stringArray.length < 2) {
                        throw new IllegalArgumentException();
                    }
                    String[] stringArray2 = null;
                    if (stringArray.length > 2) {
                        stringArray2 = new String[stringArray.length - 2];
                        for (int i = 2; i < stringArray.length; ++i) {
                            stringArray2[i - 2] = stringArray[i];
                        }
                    }
                    new TarReader(new File(stringArray[1]), 0, stringArray2, new Integer(DbBackup.generateBufferBlockValue(new File(stringArray[1]))), null).read();
                    break block13;
                }
                if (stringArray[0].equals("--extract")) {
                    int n;
                    boolean bl = stringArray.length > 1 && stringArray[1].equals("--overwrite");
                    int n2 = n = bl ? 4 : 3;
                    if (stringArray.length < n) {
                        throw new IllegalArgumentException();
                    }
                    String[] stringArray3 = null;
                    if (stringArray.length > n) {
                        stringArray3 = new String[stringArray.length - n];
                        for (int i = n; i < stringArray.length; ++i) {
                            stringArray3[i - n] = stringArray[i];
                        }
                    }
                    File file = new File(stringArray[bl ? 2 : 1]);
                    int n3 = bl ? 2 : 1;
                    new TarReader(file, n3, stringArray3, new Integer(DbBackup.generateBufferBlockValue(file)), new File(stringArray[n - 1])).read();
                    break block13;
                }
                throw new IllegalArgumentException();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println(RB.DbBackup_syntaxerr.getString(DbBackup.class.getName()));
                System.exit(2);
            }
        }
    }

    public DbBackup(File file, String string) {
        this.archiveFile = file;
        File file2 = new File(string);
        this.dbDir = file2.getAbsoluteFile().getParentFile();
        this.instanceName = file2.getName();
    }

    public void setOverWrite(boolean bl) {
        this.overWrite = bl;
    }

    public void setAbortUponModify(boolean bl) {
        this.abortUponModify = bl;
    }

    public boolean getOverWrite() {
        return this.overWrite;
    }

    public boolean getAbortUponModify() {
        return this.abortUponModify;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws IOException, TarMalformatException {
        File file = new File(this.dbDir, this.instanceName + ".properties");
        File file2 = new File(this.dbDir, this.instanceName + ".script");
        File[] fileArray = new File[]{file, file2, new File(this.dbDir, this.instanceName + ".backup"), new File(this.dbDir, this.instanceName + ".data"), new File(this.dbDir, this.instanceName + ".log"), new File(this.dbDir, this.instanceName + ".lobs")};
        boolean[] blArray = new boolean[fileArray.length];
        long l = new Date().getTime();
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = fileArray[i].exists();
            if (i >= 2 || blArray[i]) continue;
            throw new FileNotFoundException(RB.file_missing.getString(fileArray[i].getAbsolutePath()));
        }
        if (this.abortUponModify) {
            Properties properties = new Properties();
            File[] fileArray2 = null;
            try {
                fileArray2 = new FileInputStream(file);
                properties.load((InputStream)fileArray2);
            }
            finally {
                try {
                    if (fileArray2 != null) {
                        fileArray2.close();
                    }
                }
                finally {
                    fileArray2 = null;
                }
            }
            String string = properties.getProperty("modified");
            if (string != null && (string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true"))) {
                throw new IllegalStateException(RB.modified_property.getString(string));
            }
        }
        TarGenerator tarGenerator = new TarGenerator(this.archiveFile, this.overWrite, new Integer(DbBackup.generateBufferBlockValue(fileArray)));
        for (File file3 : fileArray) {
            if (!file3.exists()) continue;
            tarGenerator.queueEntry(file3.getName(), file3);
        }
        tarGenerator.write();
        if (this.abortUponModify) {
            try {
                for (int i = 0; i < fileArray.length; ++i) {
                    if (fileArray[i].exists()) {
                        if (!blArray[i]) {
                            throw new FileNotFoundException(RB.file_disappeared.getString(fileArray[i].getAbsolutePath()));
                        }
                        if (fileArray[i].lastModified() <= l) continue;
                        throw new FileNotFoundException(RB.file_changed.getString(fileArray[i].getAbsolutePath()));
                    }
                    if (!blArray[i]) continue;
                    throw new FileNotFoundException(RB.file_appeared.getString(fileArray[i].getAbsolutePath()));
                }
            }
            catch (IllegalStateException illegalStateException) {
                if (!this.archiveFile.delete()) {
                    System.out.println(RB.cleanup_rmfail.getString(this.archiveFile.getAbsolutePath()));
                }
                throw illegalStateException;
            }
        }
    }

    protected static int generateBufferBlockValue(File[] fileArray) {
        long l = 0L;
        for (File file : fileArray) {
            if (file == null || file.length() <= l) continue;
            l = file.length();
        }
        int n = (int)(l / 5120L);
        if (n < 1) {
            return 1;
        }
        if (n > 40960) {
            return 40960;
        }
        return n;
    }

    protected static int generateBufferBlockValue(File file) {
        return DbBackup.generateBufferBlockValue(new File[]{file});
    }
}

