/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer.similarity;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.plotter.PlotterAdapter;
import com.rapidminer.gui.renderer.AbstractRenderer;
import com.rapidminer.gui.renderer.DefaultReadable;
import com.rapidminer.gui.viewer.SimilarityKDistanceVisualization;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.similarity.SimilarityMeasure;
import com.rapidminer.report.Reportable;
import java.awt.Component;
import javax.swing.JLabel;

public class SimilarityKDistanceRenderer
extends AbstractRenderer {
    public String getName() {
        return "k-distances";
    }

    private PlotterAdapter createKDistancePlotter(Object renderable, ExampleSet exampleSet) {
        SimilarityMeasure sim = (SimilarityMeasure)renderable;
        return new SimilarityKDistanceVisualization(sim.getDistanceMeasure(), exampleSet);
    }

    public Reportable createReportable(Object renderable, IOContainer ioContainer, int width, int height) {
        try {
            ExampleSet exampleSet = ioContainer.get(ExampleSet.class);
            PlotterAdapter plotter = this.createKDistancePlotter(renderable, exampleSet);
            plotter.getPlotter().setSize(width, height);
            return plotter;
        }
        catch (MissingIOObjectException e) {
            return new DefaultReadable("No exampleset provided for similarity calculation");
        }
    }

    public Component getVisualizationComponent(Object renderable, IOContainer ioContainer) {
        try {
            ExampleSet exampleSet = ioContainer.get(ExampleSet.class);
            return this.createKDistancePlotter(renderable, exampleSet);
        }
        catch (MissingIOObjectException e) {
            return new JLabel("No exampleset provided for similarity calculation");
        }
    }
}

