/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.ConditionedExampleSet;
import com.rapidminer.example.set.NoMissingAttributeValueCondition;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterModel2ExampleSet
extends Operator {
    public static final String PARAMETER_KEEP_MODEL = "keep_model";
    public static final String PARAMETER_REMOVE_UNLABELED = "remove_unlabeled";
    public static final String PARAMETER_ADD_AS_LABEL = "add_as_label";

    public ClusterModel2ExampleSet(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        Attribute targetAttribute;
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        Attributes attributes = exampleSet.getAttributes();
        ClusterModel model = this.getInput(ClusterModel.class);
        model.checkCapabilities(exampleSet);
        if (!this.getParameterAsBoolean(PARAMETER_ADD_AS_LABEL)) {
            targetAttribute = AttributeFactory.createAttribute("cluster", 1);
            exampleSet.getExampleTable().addAttribute(targetAttribute);
            attributes.setCluster(targetAttribute);
        } else {
            targetAttribute = AttributeFactory.createAttribute("label", 1);
            exampleSet.getExampleTable().addAttribute(targetAttribute);
            attributes.setLabel(targetAttribute);
        }
        int[] clusterIndices = model.getClusterAssignments(exampleSet);
        int i = 0;
        for (Example example : exampleSet) {
            if (clusterIndices[i] != -1) {
                example.setValue(targetAttribute, "cluster_" + clusterIndices[i]);
            } else {
                example.setValue(targetAttribute, Double.NaN);
            }
            ++i;
        }
        if (this.getParameterAsBoolean(PARAMETER_REMOVE_UNLABELED)) {
            exampleSet = new ConditionedExampleSet(exampleSet, new NoMissingAttributeValueCondition(exampleSet, targetAttribute.getName()));
        }
        if (this.getParameterAsBoolean(PARAMETER_KEEP_MODEL)) {
            return new IOObject[]{exampleSet, model};
        }
        return new IOObject[]{exampleSet};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ClusterModel.class, ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ClusterModel.class, ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_KEEP_MODEL, "Specifies if input model should be kept.", true));
        types.add(new ParameterTypeBoolean(PARAMETER_ADD_AS_LABEL, "Should the cluster values be added as label.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_REMOVE_UNLABELED, "Delete the unlabeled examples.", false));
        return types;
    }
}

