/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.postprocessing;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.AbstractExampleSetProcessing;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.tools.Ontology;

public class WindowExamples2OriginalData
extends AbstractExampleSetProcessing {
    public WindowExamples2OriginalData(OperatorDescription description) {
        super(description);
    }

    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        Attribute labelAttribute = exampleSet.getAttributes().getLabel();
        Attribute predictedLabelAttribute = exampleSet.getAttributes().getPredictedLabel();
        Attribute baseValueAttribute = exampleSet.getAttributes().getSpecial("base_value");
        if (baseValueAttribute == null) {
            throw new UserError((Operator)this, 111, "base_value");
        }
        if (baseValueAttribute.isNominal()) {
            throw new UserError((Operator)this, 120, baseValueAttribute.getName(), Ontology.VALUE_TYPE_NAMES[baseValueAttribute.getValueType()], "non-nominal");
        }
        if (predictedLabelAttribute != null && predictedLabelAttribute.isNominal()) {
            throw new UserError((Operator)this, 120, predictedLabelAttribute.getName(), Ontology.VALUE_TYPE_NAMES[predictedLabelAttribute.getValueType()], "non-nominal");
        }
        if (labelAttribute != null && labelAttribute.isNominal()) {
            throw new UserError((Operator)this, 120, labelAttribute.getName(), Ontology.VALUE_TYPE_NAMES[labelAttribute.getValueType()], "non-nominal");
        }
        if (predictedLabelAttribute == null && labelAttribute == null) {
            this.logWarning("Neither label nor predicted label is available: do nothing.");
        }
        Attribute newLabelAttribute = null;
        if (labelAttribute != null) {
            newLabelAttribute = AttributeFactory.createAttribute(String.valueOf(labelAttribute.getName()) + "_original", labelAttribute.getValueType());
            exampleSet.getExampleTable().addAttribute(newLabelAttribute);
            exampleSet.getAttributes().addRegular(newLabelAttribute);
        }
        Attribute newPredictedLabelAttribute = null;
        if (predictedLabelAttribute != null) {
            newPredictedLabelAttribute = AttributeFactory.createAttribute(String.valueOf(predictedLabelAttribute.getName()) + "_original", predictedLabelAttribute.getValueType());
            exampleSet.getExampleTable().addAttribute(newPredictedLabelAttribute);
            exampleSet.getAttributes().addRegular(newPredictedLabelAttribute);
        }
        for (Example example : exampleSet) {
            double baseValue = example.getValue(baseValueAttribute);
            if (labelAttribute != null) {
                double labelValue = example.getValue(labelAttribute);
                example.setValue(newLabelAttribute, baseValue + labelValue);
            }
            if (predictedLabelAttribute == null) continue;
            double predictedLabelValue = example.getValue(predictedLabelAttribute);
            example.setValue(newPredictedLabelAttribute, baseValue + predictedLabelValue);
        }
        if (labelAttribute != null) {
            exampleSet.getAttributes().remove(labelAttribute);
        }
        if (predictedLabelAttribute != null) {
            exampleSet.getAttributes().remove(predictedLabelAttribute);
        }
        exampleSet.getAttributes().remove(baseValueAttribute);
        if (newLabelAttribute != null) {
            exampleSet.getAttributes().setLabel(newLabelAttribute);
        }
        if (newPredictedLabelAttribute != null) {
            exampleSet.getAttributes().setPredictedLabel(newPredictedLabelAttribute);
        }
        return exampleSet;
    }
}

