/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.distributions;

import be.ac.ulg.montefiore.run.distributions.GaussianDistribution;
import be.ac.ulg.montefiore.run.distributions.RandomDistribution;
import java.util.Arrays;
import java.util.Random;

public class GaussianMixtureDistribution
implements RandomDistribution {
    private static final Random random = new Random();
    private GaussianDistribution[] distributions;
    private double[] proportions;
    private static final long serialVersionUID = 2634624658500627331L;

    public GaussianMixtureDistribution(int nbGaussians) {
        if (nbGaussians <= 0) {
            throw new IllegalArgumentException("Argument must be strictly positive");
        }
        this.distributions = new GaussianDistribution[nbGaussians];
        this.proportions = new double[nbGaussians];
        double[] means = new double[nbGaussians];
        double[] variances = new double[nbGaussians];
        int i = 0;
        while (i < nbGaussians) {
            means[i] = (1.0 + 2.0 * (double)i) / (2.0 * (double)nbGaussians);
            ++i;
        }
        Arrays.fill(variances, 1.0);
        Arrays.fill(this.proportions, 1.0 / (double)nbGaussians);
        i = 0;
        while (i < this.distributions.length) {
            this.distributions[i] = new GaussianDistribution(means[i], variances[i]);
            ++i;
        }
    }

    public GaussianMixtureDistribution(double[] means, double[] variances, double[] proportions) {
        if (means.length == 0 || means.length != variances.length || means.length != proportions.length) {
            throw new IllegalArgumentException();
        }
        this.distributions = new GaussianDistribution[means.length];
        this.proportions = new double[means.length];
        int i = 0;
        while (i < this.distributions.length) {
            this.distributions[i] = new GaussianDistribution(means[i], variances[i]);
            ++i;
        }
        double sum = 0.0;
        int i2 = 0;
        while (i2 < proportions.length) {
            sum += proportions[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < proportions.length) {
            this.proportions[i2] = proportions[i2] / sum;
            ++i2;
        }
    }

    public int nbGaussians() {
        return this.distributions.length;
    }

    public GaussianDistribution[] distributions() {
        return (GaussianDistribution[])this.distributions.clone();
    }

    public double[] proportions() {
        return (double[])this.proportions.clone();
    }

    public double generate() {
        double r = random.nextDouble();
        double sum = 0.0;
        int i = 0;
        while (i < this.proportions.length) {
            if (r <= (sum += this.proportions[i])) {
                return this.distributions[i].generate();
            }
            ++i;
        }
        throw new RuntimeException("Internal error");
    }

    public double probability(double n) {
        double sum = 0.0;
        int i = 0;
        while (i < this.distributions.length) {
            sum += this.distributions[i].probability(n) * this.proportions[i];
            ++i;
        }
        return sum;
    }
}

