/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.charts;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.FastScatterPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;

public class ChartPanelShiftController
implements MouseMotionListener,
MouseListener {
    public static final int SHIFT_PERCENTUAL = 1;
    public static final int SHIFT_PIXEL = 2;
    public static final int SHIFT_FIXED = 3;
    private ChartPanel chartPanel;
    private boolean plotSupported = false;
    private int shiftType = 2;
    private double fixedDomainShiftUnits;
    private double fixedRangeShiftUnits;
    private int oldx = -1;
    private int oldy = -1;
    private boolean axesSwaped = false;
    private boolean onlyXShift = false;

    public ChartPanelShiftController(ChartPanel chartPanel) {
        this.chartPanel = chartPanel;
        Plot plot = chartPanel.getChart().getPlot();
        if (plot instanceof XYPlot || plot instanceof FastScatterPlot) {
            this.plotSupported = true;
            this.axesSwaped = this.isHorizontalPlot(plot);
        }
    }

    public void setOnlyXShift(boolean onlyXShift) {
        this.onlyXShift = onlyXShift;
    }

    protected boolean isHorizontalPlot(Plot plot) {
        if (plot instanceof XYPlot) {
            return ((XYPlot)plot).getOrientation() == PlotOrientation.HORIZONTAL;
        }
        if (plot instanceof FastScatterPlot) {
            return ((FastScatterPlot)plot).getOrientation() == PlotOrientation.HORIZONTAL;
        }
        return false;
    }

    protected ValueAxis[] getPlotAxis(JFreeChart chart, boolean domain) {
        Plot plot = chart.getPlot();
        if (plot instanceof XYPlot) {
            XYPlot xyPlot = (XYPlot)plot;
            if (domain) {
                ValueAxis[] rangeAxes = new ValueAxis[xyPlot.getDomainAxisCount()];
                int i = 0;
                while (i < rangeAxes.length) {
                    rangeAxes[i] = xyPlot.getDomainAxis(i);
                    ++i;
                }
                return rangeAxes;
            }
            ValueAxis[] rangeAxes = new ValueAxis[xyPlot.getRangeAxisCount()];
            int i = 0;
            while (i < rangeAxes.length) {
                rangeAxes[i] = xyPlot.getRangeAxis(i);
                ++i;
            }
            return rangeAxes;
        }
        if (plot instanceof FastScatterPlot) {
            ValueAxis[] valueAxisArray;
            if (domain) {
                ValueAxis[] valueAxisArray2 = new ValueAxis[1];
                valueAxisArray = valueAxisArray2;
                valueAxisArray2[0] = ((FastScatterPlot)plot).getDomainAxis();
            } else {
                ValueAxis[] valueAxisArray3 = new ValueAxis[1];
                valueAxisArray = valueAxisArray3;
                valueAxisArray3[0] = ((FastScatterPlot)plot).getRangeAxis();
            }
            return valueAxisArray;
        }
        return null;
    }

    public void keyPressed(KeyEvent e) {
        if (!this.plotSupported) {
            return;
        }
        int keyCode = e.getKeyCode();
        if (keyCode < 37 || keyCode > 40) {
            return;
        }
        ValueAxis[] axes = null;
        boolean domainShift = false;
        if (keyCode == 37 || keyCode == 39) {
            axes = this.getPlotAxis(this.chartPanel.getChart(), !this.axesSwaped);
            domainShift = true;
        } else {
            axes = this.getPlotAxis(this.chartPanel.getChart(), this.axesSwaped);
        }
        double[] delta = new double[axes.length];
        int i = 0;
        while (i < axes.length) {
            switch (this.shiftType) {
                case 1: {
                    delta[i] = (axes[i].getUpperBound() - axes[i].getLowerBound()) / 100.0;
                    break;
                }
                case 3: {
                    delta[i] = domainShift ? this.fixedDomainShiftUnits : this.fixedRangeShiftUnits;
                    break;
                }
                default: {
                    Rectangle2D scaledDataArea = this.chartPanel.getScreenDataArea();
                    delta[i] = axes[i].getRange().getLength() / scaledDataArea.getWidth();
                }
            }
            ++i;
        }
        if (e.isShiftDown()) {
            i = 0;
            while (i < delta.length) {
                int n = i++;
                delta[n] = delta[n] * 10.0;
            }
        }
        i = 0;
        while (i < axes.length) {
            switch (keyCode) {
                case 37: 
                case 40: {
                    axes[i].setRange(axes[i].getLowerBound() - delta[i], axes[i].getUpperBound() - delta[i]);
                    break;
                }
                case 38: 
                case 39: {
                    axes[i].setRange(axes[i].getLowerBound() + delta[i], axes[i].getUpperBound() + delta[i]);
                }
            }
            ++i;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!mouseEvent.isControlDown()) {
            return;
        }
        if (this.oldx > -1 && this.oldy > -1) {
            ValueAxis[] domAxes = this.getPlotAxis(this.chartPanel.getChart(), !this.axesSwaped);
            ValueAxis[] rngAxes = this.getPlotAxis(this.chartPanel.getChart(), this.axesSwaped);
            int xdif = mouseEvent.getX() - this.oldx;
            int ydif = mouseEvent.getY() - this.oldy;
            Rectangle2D scaledDataArea = this.chartPanel.getScreenDataArea();
            double[] xDelta = new double[domAxes.length];
            double[] yDelta = new double[rngAxes.length];
            int i = 0;
            while (i < domAxes.length) {
                xDelta[i] = (double)xdif * domAxes[i].getRange().getLength() / scaledDataArea.getWidth();
                ++i;
            }
            i = 0;
            while (i < rngAxes.length) {
                yDelta[i] = (double)ydif * rngAxes[i].getRange().getLength() / scaledDataArea.getHeight();
                ++i;
            }
            i = 0;
            while (i < domAxes.length) {
                domAxes[i].setRange(domAxes[i].getLowerBound() - xDelta[i], domAxes[i].getUpperBound() - xDelta[i]);
                ++i;
            }
            if (!this.onlyXShift) {
                i = 0;
                while (i < rngAxes.length) {
                    rngAxes[i].setRange(rngAxes[i].getLowerBound() + yDelta[i], rngAxes[i].getUpperBound() + yDelta[i]);
                    ++i;
                }
            }
        }
        this.oldx = mouseEvent.getX();
        this.oldy = mouseEvent.getY();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.oldx = -1;
        this.oldy = -1;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public double getFixedDomainShiftUnits() {
        return this.fixedDomainShiftUnits;
    }

    public void setFixedDomainShiftUnits(double fixedDomainShiftUnits) {
        this.fixedDomainShiftUnits = fixedDomainShiftUnits;
    }

    public double getFixedRangeShiftUnits() {
        return this.fixedRangeShiftUnits;
    }

    public void setFixedRangeShiftUnits(double fixedRangeShiftUnits) {
        this.fixedRangeShiftUnits = fixedRangeShiftUnits;
    }

    public int getShiftType() {
        return this.shiftType;
    }

    public void setShiftType(int shiftType) {
        this.shiftType = shiftType;
    }

    public boolean isPlotSupported() {
        return this.plotSupported;
    }
}

