/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties;

import com.rapidminer.gui.properties.ListPropertyDialog;
import com.rapidminer.gui.properties.PropertyValueCellEditor;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.Parameters;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JTable;

public class ListValueCellEditor
extends AbstractCellEditor
implements PropertyValueCellEditor {
    private static final long serialVersionUID = -4429790999365057931L;
    private ParameterTypeList type;
    private JButton button = new JButton("Edit List...");
    private List<String[]> parameterList = new LinkedList<String[]>();

    public ListValueCellEditor(ParameterTypeList type) {
        this.type = type;
        this.button.setMargin(new Insets(0, 0, 0, 0));
        this.button.setToolTipText(type.getDescription());
        this.setButtonText();
    }

    public void setOperator(final Operator operator) {
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ListPropertyDialog dialog = new ListPropertyDialog(ListValueCellEditor.this.type, ListValueCellEditor.this.parameterList, operator);
                dialog.setVisible(true);
                if (dialog.isOk()) {
                    ListValueCellEditor.this.fireEditingStopped();
                    ListValueCellEditor.this.setButtonText();
                } else {
                    ListValueCellEditor.this.fireEditingCanceled();
                }
            }
        });
    }

    public Object getCellEditorValue() {
        return this.parameterList;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        this.parameterList = Parameters.transformString2List((String)value);
        this.setButtonText();
        return this.button;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public boolean useEditorAsRenderer() {
        return true;
    }

    private void setButtonText() {
        this.button.setText("Edit List (" + this.parameterList.size() + ")...");
    }
}

