/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties;

import com.rapidminer.Process;
import com.rapidminer.gui.properties.ParameterChangeListener;
import com.rapidminer.gui.properties.PropertyKeyCellEditor;
import com.rapidminer.gui.properties.PropertyTable;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeStringCategory;

public class PropertyTableParameterChangeListener
implements ParameterChangeListener {
    private PropertyTable propertyTable;

    public PropertyTableParameterChangeListener(PropertyTable propertyTable) {
        this.propertyTable = propertyTable;
    }

    public void parameterSelectionChanged(Operator parentOperator, String operatorName, String parameterName) {
        ParameterType parameterType;
        Operator paramOp;
        Process process;
        if (parentOperator != null && (process = parentOperator.getProcess()) != null && (paramOp = process.getOperator(operatorName)) != null && (parameterType = paramOp.getParameterType(parameterName)) != null) {
            Object defaultValue;
            ParameterTypeSingle categoryType;
            String range = null;
            if (parameterType instanceof ParameterTypeBoolean) {
                range = "true, false";
            } else if (parameterType instanceof ParameterTypeCategory) {
                categoryType = (ParameterTypeCategory)parameterType;
                StringBuffer rangeBuffer = new StringBuffer();
                int i = 0;
                while (i < ((ParameterTypeCategory)categoryType).getNumberOfCategories()) {
                    if (i != 0) {
                        rangeBuffer.append(", ");
                    }
                    rangeBuffer.append(((ParameterTypeCategory)categoryType).getCategory(i));
                    ++i;
                }
                range = rangeBuffer.toString();
            } else if (parameterType instanceof ParameterTypeStringCategory) {
                categoryType = (ParameterTypeStringCategory)parameterType;
                boolean first = true;
                StringBuffer rangeBuffer = new StringBuffer();
                String[] stringArray = ((ParameterTypeStringCategory)categoryType).getValues();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String category = stringArray[n2];
                    if (!first) {
                        rangeBuffer.append(", ");
                    }
                    rangeBuffer.append(category);
                    first = false;
                    ++n2;
                }
                range = rangeBuffer.toString();
            }
            if (range == null && (defaultValue = parameterType.getDefaultValue()) != null) {
                range = defaultValue.toString();
            }
            int r = this.propertyTable.getNumberOfKeyEditors() - 1;
            while (r >= 0) {
                String keyValue;
                PropertyKeyCellEditor keyEditor = this.propertyTable.getKeyEditor(r);
                if (keyEditor != null && (keyValue = (String)keyEditor.getCellEditorValue()) != null && keyValue.startsWith(String.valueOf(operatorName) + "." + parameterName)) {
                    this.propertyTable.getModel().setValueAt(range, r, 1);
                    break;
                }
                --r;
            }
        }
    }
}

