/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer;

import com.rapidminer.gui.renderer.Renderer;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeColor;
import com.rapidminer.parameter.Parameters;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.math.StringToMatrixConverter;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRenderer
implements Renderer {
    private Parameters parameters;

    @Override
    public List<ParameterType> getParameterTypes() {
        return new LinkedList<ParameterType>();
    }

    @Override
    public String getParameter(String key) throws UndefinedParameterError {
        return this.getParameters().getParameter(key);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public boolean getParameterAsBoolean(String key) {
        try {
            return Boolean.valueOf(this.getParameter(key));
        }
        catch (UndefinedParameterError e) {
            return false;
        }
    }

    @Override
    public Color getParameterAsColor(String key) throws UndefinedParameterError {
        return ParameterTypeColor.string2Color(this.getParameter(key));
    }

    @Override
    public double getParameterAsDouble(String key) throws UndefinedParameterError {
        return Double.valueOf(this.getParameter(key));
    }

    @Override
    public InputStream getParameterAsInputStream(String key) throws UndefinedParameterError, IOException {
        String urlString = this.getParameter(key);
        if (urlString == null) {
            return null;
        }
        try {
            URL url = new URL(urlString);
            InputStream stream = url.openStream();
            return stream;
        }
        catch (MalformedURLException e) {
            File file = this.getParameterAsFile(key);
            if (file != null) {
                return new FileInputStream(file);
            }
            return null;
        }
    }

    @Override
    public File getParameterAsFile(String key) throws UndefinedParameterError {
        return this.getParameterAsFile(key, false);
    }

    @Override
    public File getParameterAsFile(String key, boolean createMissingDirectories) throws UndefinedParameterError {
        return new File(this.getParameter(key));
    }

    @Override
    public int getParameterAsInt(String key) throws UndefinedParameterError {
        return Integer.valueOf(this.getParameter(key));
    }

    @Override
    public double[][] getParameterAsMatrix(String key) throws UndefinedParameterError {
        String matrixLine = this.getParameter(key);
        try {
            return StringToMatrixConverter.parseMatlabString(matrixLine);
        }
        catch (OperatorException e) {
            throw new UndefinedParameterError(e.getMessage());
        }
    }

    @Override
    public String getParameterAsString(String key) throws UndefinedParameterError {
        return this.getParameter(key);
    }

    @Override
    public List<String[]> getParameterList(String key) throws UndefinedParameterError {
        return Parameters.transformString2List(this.getParameter(key));
    }

    @Override
    public boolean isParameterSet(String key) throws UndefinedParameterError {
        return this.getParameter(key) != null;
    }

    @Override
    public void setListParameter(String key, List<String[]> list) {
        this.parameters.setParameter(key, Parameters.transformList2String(list));
    }

    @Override
    public void setParameter(String key, String value) {
        this.parameters.setParameter(key, value);
    }

    @Override
    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    @Override
    public Parameters getParameters() {
        if (this.parameters == null) {
            this.parameters = new Parameters(this.getParameterTypes());
        }
        return this.parameters;
    }
}

