/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.viewer;

import com.rapidminer.ObjectVisualizer;
import com.rapidminer.operator.clustering.Cluster;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.operator.clustering.HierarchicalClusterModel;
import com.rapidminer.operator.clustering.HierarchicalClusterNode;
import com.rapidminer.report.Renderable;
import com.rapidminer.tools.ObjectVisualizerService;
import java.awt.Graphics;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class ClusterTreeVisualization
extends JTree
implements TreeSelectionListener,
Renderable {
    private static final long serialVersionUID = 3994390578811027103L;

    public ClusterTreeVisualization(HierarchicalClusterModel cm) {
        DefaultTreeModel model = new DefaultTreeModel(this.generateTreeModel(cm.getRootNode()));
        this.setModel(model);
        this.addTreeSelectionListener(this);
    }

    public ClusterTreeVisualization(ClusterModel cm) {
        DefaultTreeModel model = new DefaultTreeModel(this.generateFlatModel(cm));
        this.setModel(model);
        this.addTreeSelectionListener(this);
    }

    private DefaultMutableTreeNode generateFlatModel(ClusterModel cm) {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("root");
        rootNode.setAllowsChildren(true);
        int i = 0;
        while (i < cm.getNumberOfClusters()) {
            Cluster cl = cm.getCluster(i);
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(cl);
            newNode.setAllowsChildren(true);
            rootNode.add(newNode);
            for (Object exampleId : cl.getExampleIds()) {
                if (exampleId instanceof String) {
                    newNode.add(this.createLeaf((String)exampleId));
                    continue;
                }
                newNode.add(this.createLeaf((Double)exampleId));
            }
            ++i;
        }
        return rootNode;
    }

    private DefaultMutableTreeNode generateTreeModel(HierarchicalClusterNode cl) {
        DefaultMutableTreeNode result = new DefaultMutableTreeNode(cl);
        result.setAllowsChildren(true);
        for (HierarchicalClusterNode subNode : cl.getSubNodes()) {
            result.add(this.generateTreeModel(subNode));
        }
        for (Object exampleId : cl.getExampleIdsInSubtree()) {
            result.add(this.createLeaf(exampleId));
        }
        return result;
    }

    private MutableTreeNode createLeaf(Object id) {
        ObjectVisualizer viz = ObjectVisualizerService.getVisualizerForObject(id);
        String title = viz.getTitle(id);
        if (title == null) {
            title = id instanceof String ? (String)id : ((Integer)id).toString();
        }
        DefaultMutableTreeNode newLeaf = new DefaultMutableTreeNode(new ClusterTreeLeaf(title, id));
        newLeaf.setAllowsChildren(false);
        return newLeaf;
    }

    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node;
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return;
        }
        if (paths.length == 1 && !(node = (DefaultMutableTreeNode)paths[0].getLastPathComponent()).getAllowsChildren()) {
            ClusterTreeLeaf leaf = (ClusterTreeLeaf)node.getUserObject();
            ObjectVisualizer viz = ObjectVisualizerService.getVisualizerForObject(leaf.getId());
            viz.startVisualization(leaf.getId());
        }
    }

    public void expandAll() {
        int row = 0;
        while (row < this.getRowCount()) {
            this.expandRow(row);
            ++row;
        }
    }

    public void prepareRendering() {
        this.expandAll();
    }

    public void finishRendering() {
    }

    public int getRenderHeight(int preferredHeight) {
        return Math.max(this.getPreferredSize().height, preferredHeight);
    }

    public int getRenderWidth(int preferredWidth) {
        return Math.max(this.getPreferredSize().width, preferredWidth);
    }

    public void render(Graphics graphics, int width, int height) {
        this.setSize(width, height);
        this.paint(graphics);
    }

    private static class ClusterTreeLeaf {
        private String title;
        private Object id;

        public ClusterTreeLeaf(String title, Object id) {
            this.title = title;
            this.id = id;
        }

        public String toString() {
            return this.title;
        }

        public Object getId() {
            return this.id;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

