/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering.clusterer;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.InputDescription;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleSet2ClusterModel
extends Operator {
    private static final String PARAMETER_ATTRIBUTE = "attribute";

    public ExampleSet2ClusterModel(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        Tools.checkAndCreateIds(exampleSet);
        Attribute attribute = exampleSet.getAttributes().get(this.getParameterAsString(PARAMETER_ATTRIBUTE));
        if (attribute != null) {
            if (attribute.isNominal()) {
                HashMap<Double, Integer> valueMap = new HashMap<Double, Integer>();
                int[] clusterAssignments = new int[exampleSet.size()];
                int i = 0;
                for (Example example : exampleSet) {
                    double value = example.getValue(attribute);
                    if (valueMap.containsKey(value)) {
                        clusterAssignments[i] = (Integer)valueMap.get(value);
                    } else {
                        clusterAssignments[i] = valueMap.size();
                        valueMap.put(value, valueMap.size());
                    }
                    ++i;
                }
                ClusterModel model = new ClusterModel(valueMap.size());
                model.setClusterAssignments(clusterAssignments, exampleSet);
                return new IOObject[]{model};
            }
            throw new UserError((Operator)this, 119, this.getParameterAsString(PARAMETER_ATTRIBUTE), "ExampleSet2ClusterModel");
        }
        throw new UserError((Operator)this, 111, this.getParameterAsString(PARAMETER_ATTRIBUTE));
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ClusterModel.class, ExampleSet.class};
    }

    public InputDescription getInputDescription(Class cls) {
        if (ExampleSet.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, false, true);
        }
        return super.getInputDescription(cls);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_ATTRIBUTE, "Specifies the nominal attribute used to create the cluster"));
        return types;
    }
}

