/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering.clusterer.soft;

import Jama.Matrix;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.InputDescription;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.operator.clustering.FlatFuzzyClusterModel;
import com.rapidminer.operator.clustering.clusterer.AbstractClusterer;
import com.rapidminer.operator.clustering.clusterer.KMeans;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.VectorMath;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMClusterer
extends AbstractClusterer {
    public static final String PARAMETER_ADD_CLUSTER_ATTRIBUTE = "add_cluster_attribute";
    public static final String PARAMETER_K = "k";
    public static final String PARAMETER_MAX_RUNS = "max_runs";
    public static final String PARAMETER_MAX_OPTIMIZATION_STEPS = "max_optimization_steps";
    public static final String PARAMETER_QUALITY = "quality";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";
    public static final String PARAMETER_SHOW_PROBABILITIES = "show_probabilities";
    public static final String PARAMETER_INITIALIZATION_DISTRIBUTION = "inital_distribution";
    public static final String[] INIT_DISTRIBUTION = new String[]{"randomly assigned examples", "k-means run", "average parameters"};
    public static final int RANDOMLY_ASSIGNED = 0;
    public static final int K_MEANS = 1;
    public static final int AVERAGE_PARAMETERS = 2;
    public static final String PARAMETER_CORRELATED = "correlated_attributes";
    private static final String PARAMETER_USE_LOCAL_RANDOM_SEED = "use_local_random_seed";

    public EMClusterer(OperatorDescription description) {
        super(description);
    }

    public ClusterModel createClusterModel(ExampleSet exampleSet) throws OperatorException {
        FlatFuzzyClusterModel bestModel = null;
        int restoreMaxRuns = this.getParameterAsInt(PARAMETER_MAX_RUNS);
        boolean restoreCorrelated = this.getParameterAsBoolean(PARAMETER_CORRELATED);
        boolean isCorrelated = this.getParameterAsBoolean(PARAMETER_CORRELATED);
        int k = this.getParameterAsInt(PARAMETER_K);
        int initSpecialSize = exampleSet.getAttributes().specialSize();
        double[][] exampleInClusterProbability = new double[exampleSet.size()][k];
        double max = Double.NEGATIVE_INFINITY;
        int exceptionCounter = 0;
        int iter = 0;
        while (iter < this.getParameterAsInt(PARAMETER_MAX_RUNS)) {
            block14: {
                FlatFuzzyClusterModel result = new FlatFuzzyClusterModel(k);
                FlatFuzzyClusterModel oldResult = null;
                try {
                    this.init(exampleSet, result, k, initSpecialSize, exampleInClusterProbability);
                }
                catch (OperatorCreationException e1) {
                    e1.printStackTrace();
                }
                boolean stableState = false;
                double logLikelyHood_old = Double.POSITIVE_INFINITY;
                double logLikelyHood = 0.0;
                int optiStep = 0;
                int[] clusterAssignments = new int[exampleSet.size()];
                try {
                    optiStep = 0;
                    while (optiStep < this.getParameterAsInt(PARAMETER_MAX_OPTIMIZATION_STEPS) && !stableState) {
                        stableState = true;
                        oldResult = result;
                        result = new FlatFuzzyClusterModel(k);
                        if (isCorrelated) {
                            this.expectationCorrelated(exampleSet, k, exampleInClusterProbability, oldResult);
                        } else {
                            this.expectationNonCorrelated(exampleSet, k, exampleInClusterProbability, oldResult);
                        }
                        int exampleIndex = 0;
                        while (exampleIndex < exampleSet.size()) {
                            int bestIndex = this.bestIndex(exampleIndex, k, exampleInClusterProbability);
                            if (bestIndex < 0) {
                                bestIndex = RandomGenerator.getGlobalRandomGenerator().nextInt(result.getNumberOfClusters());
                            }
                            clusterAssignments[exampleIndex] = bestIndex;
                            ++exampleIndex;
                        }
                        result.setClusterAssignments(clusterAssignments, exampleSet);
                        this.maximization(exampleSet, k, exampleInClusterProbability, result);
                        logLikelyHood = this.computeLogLikelyhood(k, exampleInClusterProbability, result);
                        double difference = logLikelyHood_old - logLikelyHood;
                        if (!(Math.abs(difference) < this.getParameterAsDouble(PARAMETER_QUALITY))) {
                            stableState = false;
                        }
                        logLikelyHood_old = logLikelyHood;
                        ++optiStep;
                    }
                }
                catch (Exception e) {
                    if (++exceptionCounter > restoreMaxRuns) {
                        if ((long)(iter - (exceptionCounter - 1)) >= Math.round((double)restoreMaxRuns * 0.49)) break;
                        JOptionPane.showMessageDialog(RapidMinerGUI.getMainFrame(), "Can't compute the inverse of the covariance matrix. Maybe the Matrix is singular. Changing option \"correlated_attributes\" to false.", "information", 1);
                        this.setParameter(PARAMETER_CORRELATED, "false");
                        this.setParameter(PARAMETER_MAX_RUNS, "" + restoreMaxRuns);
                        bestModel = (FlatFuzzyClusterModel)this.createClusterModel(exampleSet);
                        break;
                    }
                    this.setParameter(PARAMETER_MAX_RUNS, "" + (this.getParameterAsInt(PARAMETER_MAX_RUNS) + 1));
                    break block14;
                }
                if (Math.abs(logLikelyHood) > max) {
                    max = Math.abs(logLikelyHood);
                    bestModel = result;
                    if (this.showProbs()) {
                        this.setProbabilitiesInTable(exampleSet, exampleInClusterProbability);
                        bestModel.setExampleInClusterProbability(exampleInClusterProbability);
                    }
                }
            }
            ++iter;
        }
        this.setParameter(PARAMETER_MAX_RUNS, "" + restoreMaxRuns);
        this.setParameter(PARAMETER_CORRELATED, "" + restoreCorrelated);
        return bestModel;
    }

    private void init(ExampleSet exampleSet, FlatFuzzyClusterModel result, int k, int initSpecialSize, double[][] exampleInClusterProbability) throws OperatorException, OperatorCreationException {
        int distribution = this.getParameterAsInt(PARAMETER_INITIALIZATION_DISTRIBUTION);
        switch (distribution) {
            case 0: {
                double[][] clusterMeans;
                try {
                    int clustersFilled;
                    RandomGenerator random = this.getParameterAsBoolean(PARAMETER_USE_LOCAL_RANDOM_SEED) ? RandomGenerator.getRandomGenerator(this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED)) : RandomGenerator.getGlobalRandomGenerator();
                    do {
                        clustersFilled = 0;
                        clusterMeans = new double[k][exampleSet.getAttributes().size()];
                        int i = 0;
                        for (Example ex : exampleSet) {
                            int cluster = random.nextInt(k);
                            exampleInClusterProbability[i][cluster] = 1.0;
                            int j = 0;
                            for (Attribute attribute : exampleSet.getAttributes()) {
                                double[] dArray = clusterMeans[cluster];
                                int n = j++;
                                dArray[n] = dArray[n] + ex.getValue(attribute);
                            }
                            ++i;
                        }
                        i = 0;
                        while (i < k) {
                            result.setClusterMean(i, clusterMeans[i]);
                            int j = 0;
                            while (j < exampleInClusterProbability.length) {
                                if (exampleInClusterProbability[j][i] == 1.0) {
                                    ++clustersFilled;
                                    break;
                                }
                                ++j;
                            }
                            ++i;
                        }
                    } while (clustersFilled < k);
                }
                catch (UndefinedParameterError random) {
                    // empty catch block
                }
                this.computeValuesWithClusterMemberships(exampleSet, k, exampleInClusterProbability, result);
                if (!this.isCorrelated()) break;
                this.initCovarianceMatrix(exampleSet, exampleInClusterProbability, result, k);
                break;
            }
            case 1: {
                KMeans clusterAlgorithm = OperatorService.createOperator(KMeans.class);
                ExampleSet clusterSet = (ExampleSet)exampleSet.clone();
                clusterAlgorithm.setParameter(PARAMETER_K, "" + k);
                clusterAlgorithm.setParameter(PARAMETER_ADD_CLUSTER_ATTRIBUTE, "true");
                clusterSet = clusterAlgorithm.apply(new IOContainer(clusterSet)).get(ExampleSet.class);
                double[][] clusterMeans = new double[k][exampleSet.getAttributes().size()];
                int exampleIndex = 0;
                Attribute clusterAttribute = clusterSet.getAttributes().getCluster();
                for (Example example : clusterSet) {
                    int clusterIndex = (int)example.getValue(clusterAttribute);
                    exampleInClusterProbability[exampleIndex][clusterIndex] = 1.0;
                    int j = 0;
                    for (Attribute attribute : clusterSet.getAttributes()) {
                        double[] dArray = clusterMeans[clusterIndex];
                        int n = j++;
                        dArray[n] = dArray[n] + example.getValue(attribute);
                    }
                    ++exampleIndex;
                }
                int i = 0;
                while (i < k) {
                    result.setClusterMean(i, clusterMeans[i]);
                    ++i;
                }
                this.computeValuesWithClusterMemberships(exampleSet, k, exampleInClusterProbability, result);
                if (!this.isCorrelated()) break;
                this.initCovarianceMatrix(exampleSet, exampleInClusterProbability, result, k);
                break;
            }
            case 2: {
                RandomGenerator random = this.getParameterAsBoolean(PARAMETER_USE_LOCAL_RANDOM_SEED) ? RandomGenerator.getRandomGenerator(this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED)) : RandomGenerator.getGlobalRandomGenerator();
                this.initAverageParameters(exampleSet, k, exampleInClusterProbability, result, random);
                break;
            }
            default: {
                RandomGenerator random = this.getParameterAsBoolean(PARAMETER_USE_LOCAL_RANDOM_SEED) ? RandomGenerator.getRandomGenerator(this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED)) : RandomGenerator.getGlobalRandomGenerator();
                this.initAverageParameters(exampleSet, k, exampleInClusterProbability, result, random);
            }
        }
        if (this.showProbs() && exampleSet.getAttributes().specialSize() == initSpecialSize) {
            int i = 0;
            while (i < k) {
                String name = "cluster_" + i + "_probability";
                Attribute newAttribute = AttributeFactory.createAttribute(4);
                newAttribute.setName(name);
                exampleSet.getExampleTable().addAttribute(newAttribute);
                exampleSet.getAttributes().setSpecialAttribute(newAttribute, name);
                ++i;
            }
            this.setProbabilitiesInTable(exampleSet, exampleInClusterProbability);
        }
    }

    private void computeValuesWithClusterMemberships(ExampleSet exampleSet, int k, double[][] exampleInClusterProbability, FlatFuzzyClusterModel result) {
        int denominator;
        int i = 0;
        while (i < k) {
            denominator = 0;
            int j = 0;
            while (j < exampleInClusterProbability.length) {
                if (exampleInClusterProbability[j][i] == 1.0) {
                    ++denominator;
                }
                ++j;
            }
            double[] clusterMean = new double[result.getClusterMean(i).length];
            int j2 = 0;
            while (j2 < result.getClusterMean(i).length) {
                clusterMean[j2] = result.getClusterMean(i)[j2] / (double)denominator;
                ++j2;
            }
            result.setClusterMean(i, clusterMean);
            ++i;
        }
        i = 0;
        while (i < k) {
            denominator = 0;
            double clusterStDeviation = 0.0;
            int j = 0;
            while (j < exampleInClusterProbability.length) {
                if (exampleInClusterProbability[j][i] == 1.0) {
                    double[] helpVector = VectorMath.vectorSubtraction(this.exampleToArray(exampleSet.getExample(j)), result.getClusterMean(i));
                    clusterStDeviation += VectorMath.vectorMultiplication(helpVector, helpVector);
                    ++denominator;
                }
                ++j;
            }
            result.setClusterStandardDeviation(i, clusterStDeviation / (double)denominator);
            result.setClusterProbability(i, (double)denominator / (double)exampleSet.size());
            ++i;
        }
    }

    private void initCovarianceMatrix(ExampleSet exampleSet, double[][] exampleInClusterProbability, FlatFuzzyClusterModel result, int k) {
        this.expectationNonCorrelated(exampleSet, k, exampleInClusterProbability, result);
        this.computeCovarianceMatrix(exampleSet, exampleInClusterProbability, result, k);
        result.clearClusterStandardDeviations();
    }

    private void initAverageParameters(ExampleSet exampleSet, int k, double[][] exampleInClusterProbability, FlatFuzzyClusterModel result, Random random) {
        double[] max = new double[exampleSet.getAttributes().size()];
        double[] min = new double[exampleSet.getAttributes().size()];
        double[] average = new double[exampleSet.getAttributes().size()];
        int j = 0;
        while (j < min.length) {
            min[j] = Double.POSITIVE_INFINITY;
            ++j;
        }
        int i = 0;
        for (Example ex : exampleSet) {
            int j2 = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                double value = ex.getValue(attribute);
                int n = j2;
                average[n] = average[n] + value;
                if (value < min[j2]) {
                    min[j2] = value;
                } else if (value > max[j2]) {
                    max[j2] = value;
                }
                ++j2;
            }
            ++i;
        }
        int j3 = 0;
        while (j3 < average.length) {
            average[j3] = average[j3] / (double)exampleSet.size();
            ++j3;
        }
        double[] offset = VectorMath.vectorDivision(VectorMath.vectorSubtraction(max, min), k * 2);
        min = VectorMath.vectorAddition(min, this.getOffset(offset, random));
        average = VectorMath.vectorAddition(average, this.getOffset(offset, random));
        max = VectorMath.vectorAddition(max, this.getOffset(offset, random));
        double[] help = VectorMath.vectorSubtraction(average, min);
        help = VectorMath.vectorDivision(help, k / 2 + 1);
        double[] help2 = VectorMath.vectorSubtraction(max, average);
        help2 = VectorMath.vectorDivision(help2, k / 2 + 1);
        int j4 = 0;
        i = 0;
        while (i < k) {
            double clusterStDeviation;
            double[] clusterMean = new double[exampleSet.getAttributes().size()];
            if (i < k / 2) {
                clusterMean = VectorMath.vectorAddition(VectorMath.vectorMultiplication(help, i + 1), min);
                clusterStDeviation = VectorMath.vectorMultiplication(help, help);
            } else if (i == k / 2 && k % 2 == 1) {
                clusterMean = average;
                double[] help3 = VectorMath.vectorMultiplication(help, -1.0);
                clusterStDeviation = VectorMath.vectorMultiplication(help3, help3);
                clusterStDeviation += VectorMath.vectorMultiplication(help2, help2);
                clusterStDeviation /= 2.0;
            } else {
                clusterMean = VectorMath.vectorAddition(average, VectorMath.vectorMultiplication(help2, j4 + 1));
                clusterStDeviation = VectorMath.vectorMultiplication(help2, help2);
                ++j4;
            }
            double clusterProbability = 1.0 / (double)k;
            result.setClusterMean(i, clusterMean);
            result.setClusterStandardDeviation(i, clusterStDeviation);
            result.setClusterProbability(i, clusterProbability);
            ++i;
        }
        if (this.isCorrelated()) {
            this.initCovarianceMatrix(exampleSet, exampleInClusterProbability, result, k);
        }
    }

    private double[] getOffset(double[] offset, Random random) {
        double multi = 2.0 * random.nextDouble() - 1.0;
        return VectorMath.vectorMultiplication(offset, multi);
    }

    protected int bestIndex(int exampleIndex, int k, double[][] exampleInClusterProbability) throws Exception {
        int bestIndex = -1;
        double bestIndexValue = 0.0;
        int i = 0;
        while (i < k) {
            if (bestIndexValue < exampleInClusterProbability[exampleIndex][i]) {
                bestIndexValue = exampleInClusterProbability[exampleIndex][i];
                bestIndex = i;
            }
            ++i;
        }
        return bestIndex;
    }

    protected void expectationNonCorrelated(ExampleSet exampleSet, int k, double[][] exampleInClusterProbability, FlatFuzzyClusterModel oldResult) {
        int j = 0;
        for (Example ex : exampleSet) {
            double sum = 0.0;
            int i = 0;
            while (i < k) {
                double[] helpVector = VectorMath.vectorSubtraction(this.exampleToArray(ex), oldResult.getClusterMean(i));
                double stDev = oldResult.getClusterStandardDeviation(i);
                if (stDev == 0.0) {
                    stDev = 1.0E-10;
                }
                exampleInClusterProbability[j][i] = 1.0 / Math.sqrt(Math.pow(Math.PI * 2 * stDev, exampleSet.getAttributes().size())) * Math.exp(-1.0 * (VectorMath.vectorMultiplication(helpVector, helpVector) / (2.0 * stDev))) * oldResult.getClusterProbability(i);
                sum += exampleInClusterProbability[j][i];
                ++i;
            }
            i = 0;
            while (i < k) {
                exampleInClusterProbability[j][i] = exampleInClusterProbability[j][i] / sum;
                ++i;
            }
            ++j;
        }
    }

    protected void expectationCorrelated(ExampleSet exampleSet, int k, double[][] exampleInClusterProbability, FlatFuzzyClusterModel oldResult) throws Exception {
        int j = 0;
        for (Example ex : exampleSet) {
            double sum = 0.0;
            Vector<Integer> problems = new Vector<Integer>();
            int i = 0;
            while (i < k) {
                double[] helpVector = VectorMath.vectorSubtraction(this.exampleToArray(ex), oldResult.getClusterMean(i));
                double[][] helpMatrix = new double[helpVector.length][1];
                int l = 0;
                while (l < helpVector.length) {
                    helpMatrix[l][0] = helpVector[l];
                    ++l;
                }
                Matrix matrix = new Matrix(helpMatrix);
                matrix = matrix.transpose().times(new Matrix(oldResult.getClusterCovarianceMatrix(i)).inverse()).times(matrix);
                double secondPart = Math.exp(matrix.getArray()[0][0] * -0.5);
                double determinant = new Matrix(oldResult.getClusterCovarianceMatrix(i)).det();
                if (determinant < 0.0) {
                    determinant *= -1.0;
                }
                exampleInClusterProbability[j][i] = 1.0 / Math.sqrt(Math.pow(Math.PI * 2, exampleSet.getAttributes().size()) * determinant) * secondPart * oldResult.getClusterProbability(i);
                if (exampleInClusterProbability[j][i] == Double.POSITIVE_INFINITY) {
                    problems.add(i);
                }
                sum += exampleInClusterProbability[j][i];
                ++i;
            }
            i = 0;
            while (i < k) {
                exampleInClusterProbability[j][i] = problems.isEmpty() ? exampleInClusterProbability[j][i] / sum : (exampleInClusterProbability[j][i] == Double.POSITIVE_INFINITY ? 1.0 : 0.0);
                ++i;
            }
            ++j;
        }
    }

    protected void maximization(ExampleSet exampleSet, int k, double[][] exampleInClusterProbability, FlatFuzzyClusterModel result) {
        int i = 0;
        while (i < k) {
            double probabilitySum = 0.0;
            int j = 0;
            double[] clusterMean = new double[exampleSet.getAttributes().size()];
            for (Example example : exampleSet) {
                probabilitySum += exampleInClusterProbability[j][i];
                clusterMean = VectorMath.vectorAddition(clusterMean, VectorMath.vectorMultiplication(this.exampleToArray(example), exampleInClusterProbability[j][i]));
                ++j;
            }
            result.setClusterMean(i, VectorMath.vectorDivision(clusterMean, probabilitySum));
            result.setClusterProbability(i, probabilitySum / (double)exampleSet.size());
            if (!this.isCorrelated()) {
                j = 0;
                double clusterStDeviation = 0.0;
                for (Example example : exampleSet) {
                    double[] helpVector = VectorMath.vectorSubtraction(this.exampleToArray(example), result.getClusterMean(i));
                    clusterStDeviation += exampleInClusterProbability[j][i] * VectorMath.vectorMultiplication(helpVector, helpVector);
                    ++j;
                }
                result.setClusterStandardDeviation(i, clusterStDeviation / probabilitySum);
            }
            ++i;
        }
        if (this.isCorrelated()) {
            this.computeCovarianceMatrix(exampleSet, exampleInClusterProbability, result, k);
        }
    }

    private void computeCovarianceMatrix(ExampleSet exampleSet, double[][] exampleInClusterProbability, FlatFuzzyClusterModel result, int k) {
        int i = 0;
        while (i < k) {
            Matrix matrix_old = null;
            Matrix matrix = null;
            double probSum = 0.0;
            int id = 0;
            for (Example example : exampleSet) {
                double[] helpVector = VectorMath.vectorSubtraction(this.exampleToArray(example), result.getClusterMean(i));
                double[][] helpMatrix = new double[helpVector.length][1];
                int j = 0;
                while (j < helpVector.length) {
                    helpMatrix[j][0] = helpVector[j];
                    ++j;
                }
                matrix = new Matrix(helpMatrix);
                matrix = matrix.times(matrix.transpose()).times(exampleInClusterProbability[id][i]);
                probSum += exampleInClusterProbability[id][i];
                if (matrix_old != null) {
                    matrix = matrix_old.plus(matrix);
                }
                matrix_old = matrix;
                ++id;
            }
            double[][] covarianceMatrix = matrix.getArray();
            covarianceMatrix = VectorMath.matrixDivision(covarianceMatrix, probSum);
            result.setClusterCovarianceMatrix(i, covarianceMatrix);
            ++i;
        }
    }

    protected double computeLogLikelyhood(int k, double[][] exampleInClusterProbability, FlatFuzzyClusterModel resultModel) {
        double result = 0.0;
        double temp = 0.0;
        int n = 0;
        while (n < exampleInClusterProbability.length) {
            int i = 0;
            while (i < k) {
                temp += resultModel.getClusterProbability(i) * exampleInClusterProbability[n][i];
                ++i;
            }
            result += Math.log(temp);
            ++n;
        }
        return result;
    }

    private boolean showProbs() {
        return this.getParameterAsBoolean(PARAMETER_SHOW_PROBABILITIES);
    }

    private boolean isCorrelated() {
        return this.getParameterAsBoolean(PARAMETER_CORRELATED);
    }

    private void setProbabilitiesInTable(ExampleSet exampleSet, double[][] exampleInClusterProbability) throws OperatorException {
        int i = 0;
        while (i < this.getParameterAsInt(PARAMETER_K)) {
            String name = "cluster_" + i + "_probability";
            int j = 0;
            for (Example ex : exampleSet) {
                ex.setValue(exampleSet.getAttributes().get(name), exampleInClusterProbability[j][i]);
                ++j;
            }
            ++i;
        }
    }

    private double[] exampleToArray(Example example) {
        double[] result = new double[example.getAttributes().size()];
        int i = 0;
        for (Attribute attribute : example.getAttributes()) {
            result[i] = example.getValue(attribute);
            ++i;
        }
        return result;
    }

    @Override
    public ClusterModel generateClusterModel(ExampleSet exampleSet) throws OperatorException {
        ClusterModel model;
        block5: {
            int k = this.getParameterAsInt(PARAMETER_K);
            Tools.isNonEmpty(exampleSet);
            Tools.checkAndCreateIds(exampleSet);
            if (exampleSet.size() < k) {
                this.logWarning("number of clusters (k) = " + k + " > number of objects =" + exampleSet.size());
                throw new UserError((Operator)this, 142, k);
            }
            model = this.createClusterModel(exampleSet);
            Attribute idAttribute = exampleSet.getAttributes().getId();
            if (!this.getParameterAsBoolean(PARAMETER_ADD_CLUSTER_ATTRIBUTE) || !this.getParameterAsBoolean("keep_example_set")) break block5;
            Attribute cluster = AttributeFactory.createAttribute("cluster", 1);
            exampleSet.getExampleTable().addAttribute(cluster);
            exampleSet.getAttributes().setCluster(cluster);
            int i = 0;
            if (idAttribute.isNumerical()) {
                for (Example example : exampleSet) {
                    example.setValue(cluster, "cluster_" + model.getClusterIndexOfId(example.getValue(idAttribute)));
                    ++i;
                }
            } else {
                for (Example example : exampleSet) {
                    example.setValue(cluster, "cluster_" + model.getClusterIndexOfId(example.getValueAsString(idAttribute)));
                    ++i;
                }
            }
        }
        return model;
    }

    public InputDescription getInputDescription(Class cls) {
        if (ExampleSet.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, true, true);
        }
        return super.getInputDescription(cls);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_ADD_CLUSTER_ATTRIBUTE, "Indicates if a cluster id is generated as new special attribute.", true));
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_K, "The number of clusters which should be found.", 2, Integer.MAX_VALUE, 2);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_MAX_RUNS, "The maximal number of runs of this operator with random initialization that are performed.", 1, Integer.MAX_VALUE, 5));
        types.add(new ParameterTypeInt(PARAMETER_MAX_OPTIMIZATION_STEPS, "The maximal number of iterations performed for one run of this operator.", 1, Integer.MAX_VALUE, 100));
        types.add(new ParameterTypeDouble(PARAMETER_QUALITY, "The quality that must be fullfilled before the algorithm stops. (The rising of the loglikelyhood that must be undercut)", 1.0E-15, 0.1, 1.0E-10));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_LOCAL_RANDOM_SEED, "Enables the use of a local random seed.", false));
        type = new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "The local random seed (-1: use global random seed)", -1, Integer.MAX_VALUE, -1);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_USE_LOCAL_RANDOM_SEED, false, true));
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_SHOW_PROBABILITIES, "Insert probabilities for every cluster with every example in the example set.", true));
        types.add(new ParameterTypeCategory(PARAMETER_INITIALIZATION_DISTRIBUTION, "Indicates the inital distribution of the centroids.", INIT_DISTRIBUTION, 1));
        types.add(new ParameterTypeBoolean(PARAMETER_CORRELATED, "Has to be activated, if the example set contains correlated attributes.", true));
        return types;
    }
}

